/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.bounded;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalBoundedFullHistogramFacet
extends InternalHistogramFacet {
    private static final String STREAM_TYPE = "fBdHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalBoundedFullHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    private HistogramFacet.ComparatorType comparatorType;
    Object[] entries;
    List<Object> entriesList;
    boolean cachedEntries;
    int size;
    long interval;
    long offset;
    boolean normalized;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalBoundedFullHistogramFacet() {
    }

    public InternalBoundedFullHistogramFacet(String name, HistogramFacet.ComparatorType comparatorType, long interval, long offset, int size, Object[] entries, boolean cachedEntries) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.interval = interval;
        this.offset = offset;
        this.size = size;
        this.entries = entries;
        this.cachedEntries = cachedEntries;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<FullEntry> entries() {
        this.normalize();
        if (this.entriesList == null) {
            Object[] newEntries = new Object[this.size];
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            this.entriesList = Arrays.asList(newEntries);
        }
        this.releaseCache();
        return this.entriesList;
    }

    public List<FullEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    private void releaseCache() {
        if (this.cachedEntries) {
            this.cachedEntries = false;
            CacheRecycler.pushObjectArray(this.entries);
        }
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            InternalBoundedFullHistogramFacet internalFacet = (InternalBoundedFullHistogramFacet)facets.get(0);
            if (this.comparatorType != HistogramFacet.ComparatorType.KEY) {
                Arrays.sort(internalFacet.entries, this.comparatorType.comparator());
            }
            return internalFacet;
        }
        InternalBoundedFullHistogramFacet first = (InternalBoundedFullHistogramFacet)facets.get(0);
        for (int f = 1; f < facets.size(); ++f) {
            InternalBoundedFullHistogramFacet internalFacet = (InternalBoundedFullHistogramFacet)facets.get(f);
            for (int i = 0; i < this.size; ++i) {
                FullEntry aggEntry = (FullEntry)first.entries[i];
                FullEntry entry = (FullEntry)internalFacet.entries[i];
                if (aggEntry == null) {
                    first.entries[i] = entry;
                    continue;
                }
                if (entry == null) continue;
                aggEntry.count += entry.count;
                aggEntry.totalCount += entry.totalCount;
                aggEntry.total += entry.total;
                if (entry.min < aggEntry.min) {
                    aggEntry.min = entry.min;
                }
                if (!(entry.max > aggEntry.max)) continue;
                aggEntry.max = entry.max;
            }
            internalFacet.releaseCache();
        }
        if (this.comparatorType != HistogramFacet.ComparatorType.KEY) {
            Arrays.sort(first.entries, this.comparatorType.comparator());
        }
        return first;
    }

    private void normalize() {
        if (this.normalized) {
            return;
        }
        this.normalized = true;
        for (int i = 0; i < this.size; ++i) {
            FullEntry entry = (FullEntry)this.entries[i];
            if (entry == null) {
                this.entries[i] = new FullEntry((long)i * this.interval + this.offset, 0L, Double.NaN, Double.NaN, 0L, 0.0);
                continue;
            }
            entry.key = (long)i * this.interval + this.offset;
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (int i = 0; i < this.size; ++i) {
            FullEntry entry = (FullEntry)this.entries[i];
            builder.startObject();
            if (this.normalized) {
                builder.field(Fields.KEY, entry.key());
            } else {
                builder.field(Fields.KEY, (long)i * this.interval + this.offset);
            }
            if (entry == null) {
                builder.field(Fields.COUNT, 0);
                builder.field(Fields.TOTAL, 0);
                builder.field(Fields.TOTAL_COUNT, 0);
            } else {
                builder.field(Fields.COUNT, entry.count());
                builder.field(Fields.MIN, entry.min());
                builder.field(Fields.MAX, entry.max());
                builder.field(Fields.TOTAL, entry.total());
                builder.field(Fields.TOTAL_COUNT, entry.totalCount());
                builder.field(Fields.MEAN, entry.mean());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        this.releaseCache();
        return builder;
    }

    public static InternalBoundedFullHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalBoundedFullHistogramFacet facet = new InternalBoundedFullHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        this.offset = in.readLong();
        this.interval = in.readVLong();
        this.size = in.readVInt();
        this.entries = CacheRecycler.popObjectArray(this.size);
        this.cachedEntries = true;
        for (int i = 0; i < this.size; ++i) {
            if (!in.readBoolean()) continue;
            this.entries[i] = new FullEntry(i, in.readVLong(), in.readDouble(), in.readDouble(), in.readVLong(), in.readDouble());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeLong(this.offset);
        out.writeVLong(this.interval);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            FullEntry entry = (FullEntry)this.entries[i];
            if (entry == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            out.writeVLong(entry.count);
            out.writeDouble(entry.min);
            out.writeDouble(entry.max);
            out.writeVLong(entry.totalCount);
            out.writeDouble(entry.total);
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }

    public static class FullEntry
    implements HistogramFacet.Entry {
        long key;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        public FullEntry(long key, long count, double min, double max, long totalCount, double total) {
            this.key = key;
            this.count = count;
            this.min = min;
            this.max = max;
            this.totalCount = totalCount;
            this.total = total;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long getKey() {
            return this.key();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return this.total;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public long totalCount() {
            return this.totalCount;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double mean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double min() {
            return this.min;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }
}

