/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.util.List;
import org.elasticsearch.search.facet.Facet;

public interface RangeFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "range";

    public List<Entry> entries();

    public List<Entry> getEntries();

    public static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        String fromAsString;
        String toAsString;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        boolean foundInDoc;

        Entry() {
        }

        public double from() {
            return this.from;
        }

        public double getFrom() {
            return this.from();
        }

        public String fromAsString() {
            if (this.fromAsString != null) {
                return this.fromAsString;
            }
            return Double.toString(this.from);
        }

        public String getFromAsString() {
            return this.fromAsString();
        }

        public double to() {
            return this.to;
        }

        public double getTo() {
            return this.to();
        }

        public String toAsString() {
            if (this.toAsString != null) {
                return this.toAsString;
            }
            return Double.toString(this.to);
        }

        public String getToAsString() {
            return this.toAsString();
        }

        public long count() {
            return this.count;
        }

        public long getCount() {
            return this.count();
        }

        public long totalCount() {
            return this.totalCount;
        }

        public long getTotalCount() {
            return this.totalCount;
        }

        public double total() {
            return this.total;
        }

        public double getTotal() {
            return this.total();
        }

        public double mean() {
            return this.total / (double)this.totalCount;
        }

        public double getMean() {
            return this.mean();
        }

        public double min() {
            return this.min;
        }

        public double getMin() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public double getMax() {
            return this.max;
        }
    }
}

