/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.ip;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.set.hash.TLongHashSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.ip.InternalIpTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsIpOrdinalsFacetCollector
extends AbstractFacetCollector {
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final int minCount;
    private final FieldDataType fieldDataType;
    private LongFieldData fieldData;
    private final List<ReaderAggregator> aggregators;
    private ReaderAggregator current;
    long missing;
    private final TLongHashSet excluded;

    public TermsIpOrdinalsFacetCollector(String facetName, String fieldName, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<String> excluded) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] doesn't have a type, can't run terms long facet collector on it");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        if (smartMappers.mapper().fieldDataType() != FieldDataType.DefaultTypes.LONG) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] is not of long type, can't run terms long facet collector on it");
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
        if (excluded == null || excluded.isEmpty()) {
            this.excluded = null;
        } else {
            this.excluded = new TLongHashSet(excluded.size());
            for (String s : excluded) {
                this.excluded.add(Long.parseLong(s));
            }
        }
        this.minCount = allTerms ? -1 : 0;
        this.aggregators = new ArrayList<ReaderAggregator>(context.searcher().subReaders().length);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        if (this.current != null) {
            this.missing += (long)this.current.counts[0];
            if (this.current.values.length > 1) {
                this.aggregators.add(this.current);
            }
        }
        this.fieldData = (LongFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        this.current = new ReaderAggregator(this.fieldData);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachOrdinalInDoc(doc, this.current);
    }

    @Override
    public Facet facet() {
        ReaderAggregator agg;
        Object ordered;
        if (this.current != null) {
            this.missing += (long)this.current.counts[0];
            if (this.current.values.length > 1) {
                this.aggregators.add(this.current);
            }
        }
        AggregatorPriorityQueue queue = new AggregatorPriorityQueue(this.aggregators.size());
        for (ReaderAggregator aggregator : this.aggregators) {
            if (!aggregator.nextPosition()) continue;
            queue.add(aggregator);
        }
        if (this.size < 5000) {
            ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            while (queue.size() > 0) {
                agg = (ReaderAggregator)queue.top();
                long value = agg.current;
                int count = 0;
                do {
                    count += agg.counts[agg.position];
                    if (agg.nextPosition()) {
                        agg = (ReaderAggregator)queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    agg = (ReaderAggregator)queue.top();
                } while (agg != null && value == agg.current);
                if (count <= this.minCount || this.excluded != null && this.excluded.contains(value)) continue;
                InternalIpTermsFacet.LongEntry entry = new InternalIpTermsFacet.LongEntry(value, count);
                ordered.insertWithOverflow((Object)entry);
            }
            InternalIpTermsFacet.LongEntry[] list = new InternalIpTermsFacet.LongEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalIpTermsFacet.LongEntry)ordered.pop();
            }
            for (ReaderAggregator aggregator : this.aggregators) {
                CacheRecycler.pushIntArray(aggregator.counts);
            }
            return new InternalIpTermsFacet(this.facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing);
        }
        ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        while (queue.size() > 0) {
            agg = (ReaderAggregator)queue.top();
            long value = agg.current;
            int count = 0;
            do {
                count += agg.counts[agg.position];
                if (agg.nextPosition()) {
                    agg = (ReaderAggregator)queue.updateTop();
                    continue;
                }
                queue.pop();
                agg = (ReaderAggregator)queue.top();
            } while (agg != null && value == agg.current);
            if (count <= this.minCount || this.excluded != null && this.excluded.contains(value)) continue;
            InternalIpTermsFacet.LongEntry entry = new InternalIpTermsFacet.LongEntry(value, count);
            ((BoundedTreeSet)ordered).add(entry);
        }
        for (ReaderAggregator aggregator : this.aggregators) {
            CacheRecycler.pushIntArray(aggregator.counts);
        }
        return new InternalIpTermsFacet(this.facetName, this.comparatorType, this.size, (Collection<InternalIpTermsFacet.LongEntry>)ordered, this.missing);
    }

    public static class AggregatorPriorityQueue
    extends PriorityQueue<ReaderAggregator> {
        public AggregatorPriorityQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(ReaderAggregator a, ReaderAggregator b) {
            return a.current < b.current;
        }
    }

    public static class ReaderAggregator
    implements FieldData.OrdinalInDocProc {
        final long[] values;
        final int[] counts;
        int position = 0;
        long current = Integer.MIN_VALUE;

        public ReaderAggregator(LongFieldData fieldData) {
            this.values = fieldData.values();
            this.counts = CacheRecycler.popIntArray(fieldData.values().length);
        }

        @Override
        public void onOrdinal(int docId, int ordinal) {
            int n = ordinal;
            this.counts[n] = this.counts[n] + 1;
        }

        public boolean nextPosition() {
            if (++this.position >= this.values.length) {
                return false;
            }
            this.current = this.values[this.position];
            return true;
        }
    }
}

