/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import play.Play;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.Query;
import play.modules.elasticsearch.search.SearchResults;

public abstract class ElasticSearch {
    public static Client client() {
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        return plugin.client();
    }

    static <T extends Model> SearchRequestBuilder builder(QueryBuilder query, Class<T> clazz) {
        return null;
    }

    public static <T extends Model> Query query(QueryBuilder query, Class<T> clazz) {
        return new Query<T>(clazz, query);
    }

    public static <T extends Model> SearchResults search(QueryBuilder query, Class<T> clazz, AbstractFacetBuilder ... facets) {
        return ElasticSearch.search(query, clazz, false, facets);
    }

    public static <T extends Model> SearchResults searchAndHydrate(QueryBuilder queryBuilder, Class<T> clazz, AbstractFacetBuilder ... facets) {
        return ElasticSearch.search(queryBuilder, clazz, true, facets);
    }

    private static <T extends Model> SearchResults search(QueryBuilder query, Class<T> clazz, boolean hydrate, AbstractFacetBuilder ... facets) {
        Query search = ElasticSearch.query(query, clazz);
        search.hydrate(hydrate);
        for (AbstractFacetBuilder facet : facets) {
            search.addFacet(facet);
        }
        return search.fetch();
    }
}

