/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import play.Play;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.Query;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.search.SearchResults;

public abstract class ElasticSearch {
    public static Client client() {
        return ElasticSearchPlugin.client();
    }

    static <T extends Model> SearchRequestBuilder builder(QueryBuilder query, Class<T> clazz) {
        ModelMapper<T> mapper = ElasticSearchPlugin.getMapper(clazz);
        String index = mapper.getIndexName();
        SearchRequestBuilder builder = ElasticSearch.client().prepareSearch(new String[]{index}).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery(query);
        return builder;
    }

    public static <T extends Model> Query<T> query(QueryBuilder query, Class<T> clazz) {
        return new Query<T>(clazz, query);
    }

    public static <T extends Model> SearchResults<T> search(QueryBuilder query, Class<T> clazz, AbstractFacetBuilder ... facets) {
        return ElasticSearch.search(query, clazz, false, facets);
    }

    public static <T extends Model> SearchResults<T> searchAndHydrate(QueryBuilder queryBuilder, Class<T> clazz, AbstractFacetBuilder ... facets) {
        return ElasticSearch.search(queryBuilder, clazz, true, facets);
    }

    private static <T extends Model> SearchResults<T> search(QueryBuilder query, Class<T> clazz, boolean hydrate, AbstractFacetBuilder ... facets) {
        Query<T> search = ElasticSearch.query(query, clazz);
        search.hydrate(hydrate);
        for (AbstractFacetBuilder facet : facets) {
            search.addFacet(facet);
        }
        return search.fetch();
    }

    public static <T extends Model> void index(T model) {
        ElasticSearchPlugin plugin = (ElasticSearchPlugin)((Object)Play.plugin(ElasticSearchPlugin.class));
        plugin.index(model);
    }
}

