/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import org.elasticsearch.client.Client;
import play.Logger;
import play.db.Model;
import play.libs.F;
import play.modules.elasticsearch.ElasticSearchIndexEvent;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.util.ExceptionUtil;

public class ElasticSearchIndexAction
implements F.Action<ElasticSearchIndexEvent> {
    public void invoke(ElasticSearchIndexEvent message) {
        Logger.info((String)"Elastic Search - %s Event", (Object[])new Object[]{message});
        Client client = ElasticSearchPlugin.client();
        Model object = message.getObject();
        ModelMapper<?> mapper = ElasticSearchPlugin.getMapper(object.getClass());
        try {
            switch (message.getType()) {
                case INDEX: {
                    ElasticSearchAdapter.indexModel(client, mapper, object);
                    break;
                }
                case DELETE: {
                    ElasticSearchAdapter.deleteModel(client, mapper, object);
                }
            }
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }
}

