/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import play.Logger;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearch;
import play.modules.elasticsearch.search.SearchResults;
import play.modules.elasticsearch.transformer.JPATransformer;
import play.modules.elasticsearch.transformer.Transformer;

public class Query<T extends Model> {
    private final Class<T> clazz;
    private final QueryBuilder builder;
    private final List<AbstractFacetBuilder> facets;
    private final List<SortBuilder> sorts;
    private int from = -1;
    private int size = -1;
    private boolean hydrate = false;

    Query(Class<T> clazz, QueryBuilder builder) {
        Validate.notNull(clazz, (String)"clazz cannot be null");
        Validate.notNull((Object)builder, (String)"builder cannot be null");
        this.clazz = clazz;
        this.builder = builder;
        this.facets = new ArrayList<AbstractFacetBuilder>();
        this.sorts = new ArrayList<SortBuilder>();
    }

    public Query<T> from(int from) {
        this.from = from;
        return this;
    }

    public Query<T> size(int size) {
        this.size = size;
        return this;
    }

    public Query<T> hydrate(boolean hydrate) {
        this.hydrate = hydrate;
        return this;
    }

    public Query<T> addFacet(AbstractFacetBuilder facet) {
        Validate.notNull((Object)facet, (String)"facet cannot be null");
        this.facets.add(facet);
        return this;
    }

    public Query<T> addSort(String field, SortOrder order) {
        Validate.notEmpty((String)field, (String)"field cannot be null");
        Validate.notNull((Object)order, (String)"order cannot be null");
        this.sorts.add((SortBuilder)SortBuilders.fieldSort((String)field).order(order));
        return this;
    }

    public Query<T> addSort(SortBuilder sort) {
        Validate.notNull((Object)sort, (String)"sort cannot be null");
        this.sorts.add(sort);
        return this;
    }

    public SearchResults<T> fetch() {
        SearchRequestBuilder request = ElasticSearch.builder(this.builder, this.clazz);
        for (AbstractFacetBuilder facet : this.facets) {
            request.addFacet(facet);
        }
        for (SortBuilder sort : this.sorts) {
            request.addSort(sort);
        }
        if (this.from > -1) {
            request.setFrom(this.from);
        }
        if (this.size > -1) {
            request.setSize(this.size);
        }
        if (this.hydrate) {
            request.addField("_id");
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)"ES Query: %s", (Object[])new Object[]{this.builder.toString()});
        }
        SearchResponse searchResponse = (SearchResponse)request.execute().actionGet();
        SearchResults<T> searchResults = null;
        searchResults = this.hydrate ? JPATransformer.toSearchResults(searchResponse, this.clazz) : Transformer.toSearchResults(searchResponse, this.clazz);
        return searchResults;
    }
}

