/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import play.modules.elasticsearch.mapping.ModelMapper;

public abstract class MappingUtil {
    private MappingUtil() {
    }

    public static boolean isSearchable(Class<?> clazz) {
        while (clazz != null) {
            for (Annotation a : clazz.getAnnotations()) {
                if (((Object)a).toString().indexOf("ElasticSearchable") <= -1) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static XContentBuilder getMapping(ModelMapper<?> mapper) throws IOException {
        XContentBuilder builder = XContentFactory.safeJsonBuilder();
        builder.startObject();
        mapper.addMapping(builder);
        builder.endObject();
        return builder;
    }
}

