/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import org.apache.commons.lang.Validate;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.annotations.ElasticSearchField;
import play.modules.elasticsearch.mapping.FieldMapper;

public abstract class AbstractFieldMapper<M>
implements FieldMapper<M> {
    protected final Field field;
    protected final ElasticSearchField meta;

    public AbstractFieldMapper(Field field) {
        Validate.notNull((Object)field, (String)"field cannot be null");
        this.field = field;
        this.meta = field.getAnnotation(ElasticSearchField.class);
    }

    protected static void addField(String name, String type, ElasticSearchField meta, XContentBuilder builder) throws IOException {
        if (type != null) {
            builder.startObject(name);
            builder.field("type", type);
            if (meta != null) {
                if (meta.index() != ElasticSearchField.Index.NOT_SET) {
                    builder.field("index", meta.index().toString());
                }
                if (meta.store() != ElasticSearchField.Store.NOT_SET) {
                    builder.field("store", meta.store().toString());
                }
            }
            builder.endObject();
        }
    }

    protected static String detectFieldType(Class<?> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return "integer";
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return "short";
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return "long";
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return "float";
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return "double";
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            return "byte";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return "date";
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return "boolean";
        }
        return "string";
    }
}

