/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.annotations.ElasticSearchEmbedded;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MapperFactory;
import play.modules.elasticsearch.mapping.MappingException;
import play.modules.elasticsearch.mapping.impl.AbstractFieldMapper;
import play.modules.elasticsearch.mapping.impl.EmbeddedFieldMapper;
import play.modules.elasticsearch.util.ReflectionUtil;

public class CollectionFieldMapper<M>
extends AbstractFieldMapper<M> {
    private final boolean nestedMode;
    private final List<FieldMapper<Object>> fields;

    public CollectionFieldMapper(Field field) {
        super(field);
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new MappingException("field must be of Collection type");
        }
        ElasticSearchEmbedded embed = field.getAnnotation(ElasticSearchEmbedded.class);
        this.nestedMode = embed != null;
        this.fields = new ArrayList<FieldMapper<Object>>();
        if (this.nestedMode) {
            Class<?> itemClass = this.getCollectionType();
            List<Field> fieldsToIndex = EmbeddedFieldMapper.getFieldsToIndex(itemClass, embed);
            for (Field embeddedField : fieldsToIndex) {
                this.fields.add(MapperFactory.getMapper(embeddedField));
            }
        }
    }

    private Class<?> getCollectionType() {
        ParameterizedType type = (ParameterizedType)this.field.getGenericType();
        return (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public void addToMapping(XContentBuilder builder, String prefix) throws IOException {
        if (this.nestedMode) {
            builder.startObject(this.field.getName());
            builder.startObject("properties");
            for (FieldMapper<Object> mapper : this.fields) {
                mapper.addToMapping(builder, null);
            }
            builder.endObject();
            builder.endObject();
        } else {
            String type = CollectionFieldMapper.detectFieldType(this.getCollectionType());
            CollectionFieldMapper.addField(this.field.getName(), type, this.meta, builder);
        }
    }

    @Override
    public void addToDocument(M model, XContentBuilder builder, String prefix) throws IOException {
        String name = this.field.getName();
        Collection value = (Collection)ReflectionUtil.getFieldValue(model, this.field);
        if (value != null) {
            builder.startArray(name);
            if (this.nestedMode) {
                for (Object object : value) {
                    builder.startObject();
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.addToDocument(object, builder, null);
                    }
                    builder.endObject();
                }
            } else {
                for (Object object : value) {
                    builder.value(object);
                }
            }
            builder.endArray();
        }
    }
}

