/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.annotations.ElasticSearchEmbedded;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MapperFactory;
import play.modules.elasticsearch.mapping.impl.AbstractFieldMapper;
import play.modules.elasticsearch.mapping.impl.PlayModelMapper;
import play.modules.elasticsearch.util.ReflectionUtil;
import scala.actors.threadpool.Arrays;

public class EmbeddedFieldMapper<M>
extends AbstractFieldMapper<M> {
    private final ElasticSearchEmbedded embed;
    private final String prefix;
    private final List<FieldMapper<Object>> fields;

    public EmbeddedFieldMapper(Field field) {
        super(field);
        this.embed = field.getAnnotation(ElasticSearchEmbedded.class);
        this.prefix = this.embed.prefix().length() > 0 ? this.embed.prefix() : field.getName() + ".";
        this.fields = new ArrayList<FieldMapper<Object>>();
        for (Field embeddedField : EmbeddedFieldMapper.getFieldsToIndex(field.getType(), this.embed)) {
            this.fields.add(MapperFactory.getMapper(embeddedField));
        }
    }

    static List<Field> getFieldsToIndex(Class<?> clazz, ElasticSearchEmbedded meta) {
        List fieldsToIndex = Arrays.asList((Object[])meta.fields());
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field embeddedField : ReflectionUtil.getAllFields(clazz)) {
            if (PlayModelMapper.shouldIgnoreField(embeddedField) || fieldsToIndex.size() == 0 && PlayModelMapper.userRequestedIgnoreField(embeddedField) || fieldsToIndex.size() > 0 && !fieldsToIndex.contains(embeddedField.getName())) continue;
            fields.add(embeddedField);
        }
        return fields;
    }

    @Override
    public void addToMapping(XContentBuilder builder, String prefix) throws IOException {
        String name = this.field.getName();
        switch (this.embed.mode()) {
            case embedded: {
                String prefixToUse = prefix != null ? prefix + this.prefix : this.prefix;
                for (FieldMapper<Object> mapper : this.fields) {
                    mapper.addToMapping(builder, prefixToUse);
                }
                break;
            }
            case object: 
            case nested: {
                builder.startObject(name);
                builder.field("type", this.embed.mode().toString());
                builder.startObject("properties");
                for (FieldMapper<Object> mapper : this.fields) {
                    mapper.addToMapping(builder, null);
                }
                builder.endObject();
                builder.endObject();
            }
        }
    }

    @Override
    public void addToDocument(M model, XContentBuilder builder, String prefix) throws IOException {
        String name = this.field.getName();
        Object value = ReflectionUtil.getFieldValue(model, this.field);
        if (value != null) {
            switch (this.embed.mode()) {
                case embedded: {
                    String prefixToUse = prefix != null ? prefix + this.prefix : this.prefix;
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.addToDocument(value, builder, prefixToUse);
                    }
                    break;
                }
                case object: 
                case nested: {
                    builder.startObject(name);
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.addToDocument(value, builder, null);
                    }
                    builder.endObject();
                }
            }
        }
    }
}

