/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.db.Model;
import play.modules.elasticsearch.annotations.ElasticSearchIgnore;
import play.modules.elasticsearch.annotations.ElasticSearchable;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MapperFactory;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.util.ReflectionUtil;

public class PlayModelMapper<M extends Model>
implements ModelMapper<M> {
    private static List<String> IGNORE_FIELDS = new ArrayList<String>();
    private final Class<M> clazz;
    private final ElasticSearchable meta;
    private final List<FieldMapper<M>> mapping;

    public PlayModelMapper(Class<M> clazz) {
        Validate.notNull(clazz, (String)"Clazz cannot be null");
        this.clazz = clazz;
        this.meta = clazz.getAnnotation(ElasticSearchable.class);
        this.mapping = PlayModelMapper.getMapping(clazz);
    }

    static boolean shouldIgnoreField(Field field) {
        String name = field.getName();
        return StringUtils.isBlank((String)name) || IGNORE_FIELDS.contains(name);
    }

    static boolean userRequestedIgnoreField(Field field) {
        return field.isAnnotationPresent(ElasticSearchIgnore.class);
    }

    private static final <M extends Model> List<FieldMapper<M>> getMapping(Class<M> clazz) {
        ArrayList<FieldMapper<M>> mapping = new ArrayList<FieldMapper<M>>();
        List<Field> indexableFields = ReflectionUtil.getAllFields(clazz);
        for (Field field : indexableFields) {
            if (PlayModelMapper.shouldIgnoreField(field) || PlayModelMapper.userRequestedIgnoreField(field)) continue;
            FieldMapper mapper = MapperFactory.getMapper(field);
            mapping.add(mapper);
        }
        return mapping;
    }

    @Override
    public Class<M> getModelClass() {
        return this.clazz;
    }

    @Override
    public String getIndexName() {
        if (this.meta.indexName().length() > 0) {
            return this.meta.indexName();
        }
        return this.getTypeName();
    }

    @Override
    public String getTypeName() {
        return this.clazz.getName().toLowerCase().trim().replace('.', '_');
    }

    @Override
    public String getDocumentId(M model) {
        return String.valueOf(model._key());
    }

    @Override
    public void addMapping(XContentBuilder builder) throws IOException {
        builder.startObject(this.getTypeName());
        builder.startObject("properties");
        for (FieldMapper<M> field : this.mapping) {
            field.addToMapping(builder, null);
        }
        builder.endObject();
        builder.endObject();
    }

    @Override
    public void addModel(M model, XContentBuilder builder) throws IOException {
        builder.startObject();
        for (FieldMapper<M> field : this.mapping) {
            field.addToDocument(model, builder, null);
        }
        builder.endObject();
    }

    static {
        IGNORE_FIELDS.add("avoidCascadeSaveLoops");
        IGNORE_FIELDS.add("willBeSaved");
        IGNORE_FIELDS.add("serialVersionId");
        IGNORE_FIELDS.add("serialVersionUID");
    }
}

