/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.mapping.impl.AbstractFieldMapper;
import play.modules.elasticsearch.util.ReflectionUtil;

public class SimpleFieldMapper<M>
extends AbstractFieldMapper<M> {
    public SimpleFieldMapper(Field field) {
        super(field);
    }

    @Override
    public void addToMapping(XContentBuilder builder, String prefix) throws IOException {
        String name = this.field.getName();
        String type = this.getFieldType();
        if (prefix != null) {
            SimpleFieldMapper.addField(prefix + name, type, this.meta, builder);
        } else {
            SimpleFieldMapper.addField(name, type, this.meta, builder);
        }
    }

    @Override
    public void addToDocument(M model, XContentBuilder builder, String prefix) throws IOException {
        String name = this.field.getName();
        Object value = ReflectionUtil.getFieldValue(model, this.field);
        if (value != null) {
            if (prefix != null) {
                builder.field(prefix + name, value);
            } else {
                builder.field(name, value);
            }
        }
    }

    protected String getFieldType() {
        if (this.meta != null && this.meta.type().length() > 0) {
            return this.meta.type();
        }
        return SimpleFieldMapper.detectFieldType(this.field.getType());
    }
}

