/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.rabbitmq;

import akka.actor.ActorRef;
import akka.actor.Actors;
import akka.amqp.AMQP;
import akka.amqp.Direct;
import akka.amqp.Direct$;
import akka.amqp.ExchangeType;
import com.rabbitmq.client.Address;
import play.Logger;
import play.Play;
import play.modules.elasticsearch.ElasticSearchIndexEvent;
import play.modules.elasticsearch.IndexEventHandler;
import play.modules.elasticsearch.rabbitmq.RabbitMQConsumerActor;

public class RabbitMQIndexEventHandler
implements IndexEventHandler {
    private static boolean consumerStarted = false;

    @Override
    public void handle(ElasticSearchIndexEvent event) {
        if (!consumerStarted) {
            RabbitMQIndexEventHandler.startConsumer();
            consumerStarted = true;
        }
        Direct$ directExchange = Direct.getInstance();
        AMQP.ExchangeParameters params = new AMQP.ExchangeParameters(RabbitMQIndexEventHandler.getQueue(), (ExchangeType)directExchange);
        AMQP.ProducerParameters producerParams = new AMQP.ProducerParameters(params);
        Address address = new Address(RabbitMQIndexEventHandler.getHost(), RabbitMQIndexEventHandler.getPort().intValue());
        Address[] addresses = new Address[]{address};
        AMQP.ConnectionParameters connectionParameters = new AMQP.ConnectionParameters(addresses, RabbitMQIndexEventHandler.getUsername(), RabbitMQIndexEventHandler.getPassword(), RabbitMQIndexEventHandler.getVirtualHost());
        ActorRef connection = AMQP.newConnection((AMQP.ConnectionParameters)connectionParameters);
        ActorRef producer = AMQP.newProducer((ActorRef)connection, (AMQP.ProducerParameters)producerParams);
        producer.sendOneWay((Object)event);
    }

    private static String getQueue() {
        String s = Play.configuration.getProperty("elasticsearch.rabbitmq.queue");
        if (s == null) {
            return "elasticSearchQueue";
        }
        return s;
    }

    private static String getHost() {
        return Play.configuration.getProperty("elasticsearch.rabbitmq.host");
    }

    private static Integer getPort() {
        return Integer.valueOf(Play.configuration.getProperty("elasticsearch.rabbitmq.port"));
    }

    private static String getUsername() {
        return Play.configuration.getProperty("elasticsearch.rabbitmq.username");
    }

    private static String getPassword() {
        return Play.configuration.getProperty("elasticsearch.rabbitmq.password");
    }

    private static String getVirtualHost() {
        return Play.configuration.getProperty("elasticsearch.rabbitmq.virtualHost");
    }

    private static void startConsumer() {
        Logger.info((String)"Triggering RabbitMQConsumer for Elastic Search...", (Object[])new Object[0]);
        Direct$ directExchange = Direct.getInstance();
        AMQP.ExchangeParameters params = new AMQP.ExchangeParameters(RabbitMQIndexEventHandler.getQueue(), (ExchangeType)directExchange);
        Address address = new Address(RabbitMQIndexEventHandler.getHost(), RabbitMQIndexEventHandler.getPort().intValue());
        Address[] addresses = new Address[]{address};
        AMQP.ConnectionParameters connectionParameters = new AMQP.ConnectionParameters(addresses, RabbitMQIndexEventHandler.getUsername(), RabbitMQIndexEventHandler.getPassword(), RabbitMQIndexEventHandler.getVirtualHost());
        ActorRef connection = AMQP.newConnection((AMQP.ConnectionParameters)connectionParameters);
        ActorRef ref = Actors.actorOf(RabbitMQConsumerActor.class);
        AMQP.ConsumerParameters consumerParams = new AMQP.ConsumerParameters(RabbitMQIndexEventHandler.getQueue(), ref, params);
        AMQP.newConsumer((ActorRef)ref, (AMQP.ConsumerParameters)consumerParams);
    }
}

