/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import play.Logger;
import play.modules.elasticsearch.util.ExceptionUtil;

public abstract class ReflectionUtil {
    private static final ConcurrentMap<ClassAnnotationHolder, AnnotationFieldsHolder> annotationFieldsCache = new ConcurrentHashMap<ClassAnnotationHolder, AnnotationFieldsHolder>();
    private static final ConcurrentMap<String, List<Field>> classFieldsCache = new ConcurrentHashMap<String, List<Field>>();
    public static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss.SSS";

    private ReflectionUtil() {
    }

    public static List<Field> getAllFields(Class<?> originalClass) {
        Class<?> clazz = originalClass;
        String className = clazz.getCanonicalName();
        if (classFieldsCache.containsKey(className)) {
            List fields = (List)classFieldsCache.get(className);
            return fields;
        }
        int count = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
            ++count;
        }
        if (count > 10) {
            Logger.warn((String)("Too many iterations on ReflectionUtil.getAllFields() - class: " + originalClass), (Object[])new Object[0]);
        }
        List<Field> unmodifiableFields = Collections.unmodifiableList(fields);
        classFieldsCache.put(className, unmodifiableFields);
        return unmodifiableFields;
    }

    public static Object getFieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            Logger.warn((String)ExceptionUtil.getStackTrace(e), (Object[])new Object[0]);
            return null;
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    field.setAccessible(true);
                    return field.get(object);
                }
            }
        }
        catch (Exception e) {
            Logger.warn((String)ExceptionUtil.getStackTrace(e), (Object[])new Object[0]);
        }
        return null;
    }

    public static List<String> getAllFieldNamesWithType(Class<?> originalClass, Class<?> type) {
        Class<?> clazz = originalClass;
        ArrayList<String> fieldNames = new ArrayList<String>();
        int count = 0;
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!type.isAssignableFrom(field.getType())) continue;
                fieldNames.add(field.getName());
            }
            clazz = clazz.getSuperclass();
            ++count;
        }
        if (count > 10) {
            Logger.warn((String)("Too many iterations on ReflectionUtil.getFieldNamesWithType() - class: " + originalClass + " - " + type), (Object[])new Object[0]);
        }
        return fieldNames;
    }

    public static boolean hasAnnotation(Field field, Class<? extends Annotation> clazz) {
        return field.isAnnotationPresent(clazz);
    }

    public static Object newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static AnnotationFieldsHolder getAnnotationHolder(Class<?> mainClass, Class<? extends Annotation> annotationClass) {
        ClassAnnotationHolder holder = new ClassAnnotationHolder(mainClass, annotationClass);
        if (annotationFieldsCache.containsKey(holder)) {
            AnnotationFieldsHolder fieldHolder = (AnnotationFieldsHolder)annotationFieldsCache.get(holder);
            return fieldHolder;
        }
        ArrayList<Field> fieldsWithAnnotation = new ArrayList<Field>();
        List<Field> fields = ReflectionUtil.getAllFields(mainClass);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            fieldsWithAnnotation.add(field);
        }
        AnnotationFieldsHolder fieldHolder = new AnnotationFieldsHolder(fieldsWithAnnotation);
        annotationFieldsCache.put(holder, fieldHolder);
        return fieldHolder;
    }

    public static List<Field> getFieldsWithAnnotation(Class<?> mainClass, Class<? extends Annotation> annotationClass) {
        AnnotationFieldsHolder holder = ReflectionUtil.getAnnotationHolder(mainClass, annotationClass);
        return holder.getFields();
    }

    public static List<String> getFieldNamesWithAnnotation(Class<?> mainClass, Class<? extends Annotation> annotationClass) {
        AnnotationFieldsHolder holder = ReflectionUtil.getAnnotationHolder(mainClass, annotationClass);
        return holder.getFieldNames();
    }

    public static List<String> getAllFieldNamesWithoutAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        String className = clazz.getName() + ".";
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : ReflectionUtil.getAllFields(clazz)) {
            if (field.isAnnotationPresent(annotationClass)) continue;
            fieldNames.add(className + field.getName());
        }
        return fieldNames;
    }

    public static List<Field> getAllFieldsWithoutAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> fieldsWithoutAnnotation = new ArrayList<Field>();
        for (Field field : ReflectionUtil.getAllFields(clazz)) {
            if (field.isAnnotationPresent(annotationClass)) continue;
            fieldsWithoutAnnotation.add(field);
        }
        return fieldsWithoutAnnotation;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtil.getField(object, fieldName);
        ReflectionUtil.setFieldValue(object, field, value);
    }

    private static void setFieldValue(Object object, Field field, Object value) {
        Class<?> type;
        field.setAccessible(true);
        Class<?> fieldClass = type = field.getType();
        try {
            if (fieldClass.equals(value.getClass())) {
                field.set(object, value);
            } else if (fieldClass.equals(String.class)) {
                field.set(object, value.toString());
            } else if (fieldClass.equals(BigDecimal.class)) {
                field.set(object, new BigDecimal(value.toString()));
            } else if (fieldClass.equals(Date.class)) {
                field.set(object, ReflectionUtil.convertToDate(value));
            } else if (fieldClass.equals(Integer.class)) {
                if (value instanceof Number) {
                    field.set(object, ((Number)value).intValue());
                } else {
                    field.set(object, Integer.valueOf(value.toString()));
                }
            } else if (fieldClass.equals(Long.class)) {
                if (value instanceof Number) {
                    field.set(object, ((Number)value).longValue());
                } else {
                    field.set(object, Long.valueOf(value.toString()));
                }
            } else if (fieldClass.equals(Double.class)) {
                if (value instanceof Number) {
                    field.set(object, ((Number)value).doubleValue());
                } else {
                    field.set(object, Double.valueOf(value.toString()));
                }
            } else {
                field.set(object, value);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.error((String)ExceptionUtil.getStackTrace(e), (Object[])new Object[0]);
        }
        catch (IllegalAccessException e) {
            Logger.error((String)ExceptionUtil.getStackTrace(e), (Object[])new Object[0]);
        }
    }

    private static Field getField(Object object, String fieldName) {
        Object obj = object;
        if (obj == null) {
            return null;
        }
        try {
            for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field f : clazz.getDeclaredFields()) {
                    if (!f.getName().equalsIgnoreCase(fieldName)) continue;
                    return f;
                }
            }
        }
        catch (SecurityException e) {
            Logger.error((String)ExceptionUtil.getStackTrace(e), (Object[])new Object[0]);
        }
        return null;
    }

    public static Class<?> getParentClassByType(Object object, Class<?> clazz) {
        for (Class<?> clz = object.getClass(); clz != null; clz = clz.getSuperclass()) {
            if (!clz.equals(clazz)) continue;
            return clz;
        }
        return null;
    }

    public static boolean isAbstract(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return (modifiers & 0x400) > 0;
    }

    public static boolean isInterface(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return (modifiers & 0x200) > 0;
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !ReflectionUtil.isInterface(clazz) && !ReflectionUtil.isAbstract(clazz);
    }

    private static Date convertToDate(Object value) {
        Date date = null;
        if (value != null && !"".equals(value)) {
            if (value instanceof Long) {
                date = new Date((Long)value);
            } else if (value instanceof String) {
                String val = (String)value;
                int dateLength = String.valueOf(Long.MAX_VALUE).length();
                date = dateLength == val.length() ? new Date(Long.valueOf(val)) : ReflectionUtil.getDate(val);
            } else {
                date = (Date)value;
            }
        }
        return date;
    }

    private static Date getDate(String val) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.parse(val);
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[]{val});
            return null;
        }
    }

    private static class AnnotationFieldsHolder {
        private final List<Field> fields;
        private List<String> fieldNames;

        public AnnotationFieldsHolder(List<Field> fields) {
            this.fields = Collections.unmodifiableList(fields);
            this.initFieldNames();
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public List<String> getFieldNames() {
            return this.fieldNames;
        }

        private void initFieldNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (Field field : this.fields) {
                names.add(field.getName());
            }
            this.fieldNames = Collections.unmodifiableList(names);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldNames == null ? 0 : ((Object)this.fieldNames).hashCode());
            result = 31 * result + (this.fields == null ? 0 : ((Object)this.fields).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationFieldsHolder other = (AnnotationFieldsHolder)obj;
            if (this.fieldNames == null ? other.fieldNames != null : !((Object)this.fieldNames).equals(other.fieldNames)) {
                return false;
            }
            return !(this.fields == null ? other.fields != null : !((Object)this.fields).equals(other.fields));
        }
    }

    private static class ClassAnnotationHolder {
        private final Class<?> mainClass;
        private final Class<?> annotationClass;

        public ClassAnnotationHolder(Class<?> mainClass, Class<?> annotationClass) {
            this.mainClass = mainClass;
            this.annotationClass = annotationClass;
        }

        public Class<?> getMainClass() {
            return this.mainClass;
        }

        public Class<?> getAnnotationClass() {
            return this.annotationClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.annotationClass == null ? 0 : this.annotationClass.hashCode());
            result = 31 * result + (this.mainClass == null ? 0 : this.mainClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassAnnotationHolder other = (ClassAnnotationHolder)obj;
            if (this.annotationClass == null ? other.annotationClass != null : !this.annotationClass.equals(other.annotationClass)) {
                return false;
            }
            return !(this.mainClass == null ? other.mainClass != null : !this.mainClass.equals(other.mainClass));
        }
    }
}

