/*
 * Decompiled with CFR 0.152.
 */
package akka.amqp;

import akka.actor.ActorRef;
import akka.actor.Actors;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.amqp.AMQP;
import akka.amqp.AkkaAmqp;
import akka.amqp.ChannelCallbackActor;
import akka.amqp.ConnectionCallbackActor;
import akka.amqp.Direct;
import akka.amqp.DirectDeliveryHandlerActor;
import akka.amqp.DummyActor;
import akka.amqp.Message;
import akka.amqp.rpc.RPC;
import akka.japi.Creator;
import akka.japi.Function;
import akka.japi.Procedure;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import scala.Option;

public class ExampleSessionJava {
    public static void main(String ... stringArray) {
        new ExampleSessionJava();
    }

    public ExampleSessionJava() {
        this.printTopic("DIRECT");
        this.direct();
        this.printTopic("CALLBACK");
        this.callback();
        this.printTopic("EASY STRING PRODUCER AND CONSUMER");
        this.easyStringProducerConsumer();
        this.printTopic("EASY PROTOBUF PRODUCER AND CONSUMER");
        this.easyProtobufProducerConsumer();
        this.printTopic("EASY STRING RPC");
        this.easyStringRpc();
        this.printTopic("EASY PROTOBUF RPC");
        this.easyProtobufRpc();
        AMQP.shutdownAll();
        Actors.registry().shutdownAll();
        this.printTopic("Happy hAkking :-)");
        System.exit(0);
    }

    private void printTopic(String string) {
        System.out.println("");
        System.out.println("==== " + string + " ===");
        System.out.println("");
        try {
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void direct() {
        ActorRef actorRef = AMQP.newConnection();
        AMQP.ExchangeParameters exchangeParameters = new AMQP.ExchangeParameters("my_direct_exchange", Direct.getInstance());
        ActorRef actorRef2 = Actors.actorOf(DirectDeliveryHandlerActor.class);
        AMQP.ConsumerParameters consumerParameters = new AMQP.ConsumerParameters("some.routing", actorRef2, exchangeParameters);
        ActorRef actorRef3 = AMQP.newConsumer(actorRef, consumerParameters);
        ActorRef actorRef4 = AMQP.newProducer(actorRef, new AMQP.ProducerParameters(exchangeParameters));
        actorRef4.sendOneWay((Object)new Message("@jonas_boner: You sucked!!".getBytes(), "some.routing"));
    }

    private void callback() {
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        ActorRef actorRef = Actors.actorOf(ConnectionCallbackActor.class);
        actorRef.start();
        AMQP.ConnectionParameters connectionParameters = new AMQP.ConnectionParameters(actorRef);
        ActorRef actorRef2 = AMQP.newConnection(connectionParameters);
        ActorRef actorRef3 = Actors.actorOf((Creator)new UntypedActorFactory(){

            public UntypedActor create() {
                return new ChannelCallbackActor(countDownLatch);
            }
        });
        actorRef3.start();
        AMQP.ExchangeParameters exchangeParameters = new AMQP.ExchangeParameters("my_callback_exchange", Direct.getInstance());
        AMQP.ChannelParameters channelParameters = new AMQP.ChannelParameters(actorRef3);
        ActorRef actorRef4 = Actors.actorOf(DummyActor.class);
        AMQP.ConsumerParameters consumerParameters = new AMQP.ConsumerParameters("callback.routing", actorRef4, exchangeParameters, channelParameters);
        ActorRef actorRef5 = AMQP.newConsumer(actorRef2, consumerParameters);
        ActorRef actorRef6 = AMQP.newProducer(actorRef2, new AMQP.ProducerParameters(exchangeParameters, channelParameters));
        try {
            countDownLatch.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        actorRef2.stop();
    }

    public void easyStringProducerConsumer() {
        ActorRef actorRef = AMQP.newConnection();
        String string = "easy.string";
        Procedure<String> procedure = new Procedure<String>(){

            public void apply(String string) {
                System.out.println("### >> Received message: " + string);
            }
        };
        AMQP.newStringConsumer(actorRef, procedure, string);
        AMQP.ProducerClient<String> producerClient = AMQP.newStringProducer(actorRef, string);
        producerClient.send("This shit is easy!");
    }

    public void easyProtobufProducerConsumer() {
        ActorRef actorRef = AMQP.newConnection();
        String string = "easy.protobuf";
        Procedure<AkkaAmqp.TestMessage> procedure = new Procedure<AkkaAmqp.TestMessage>(){

            public void apply(AkkaAmqp.TestMessage testMessage) {
                System.out.println("### >> Received message: " + (Object)((Object)testMessage));
            }
        };
        AMQP.newProtobufConsumer(actorRef, procedure, string, AkkaAmqp.TestMessage.class);
        AMQP.ProducerClient<AkkaAmqp.TestMessage> producerClient = AMQP.newProtobufProducer(actorRef, string);
        producerClient.send(AkkaAmqp.TestMessage.newBuilder().setMessage("akka-amqp rocks!").build());
    }

    public void easyStringRpc() {
        ActorRef actorRef = AMQP.newConnection();
        String string = "easy.stringrpc";
        RPC.newStringRpcServer(actorRef, string, new Function<String, String>(){

            public String apply(String string) {
                System.out.println("### >> Got request: " + string);
                return "Response to: '" + string + "'";
            }
        });
        RPC.RpcClient<String, String> rpcClient = RPC.newStringRpcClient(actorRef, string);
        Option<String> option = rpcClient.call("AMQP Rocks!");
        System.out.println("### >> Got response: " + option);
        rpcClient.callAsync("AMQP is dead easy", new Procedure<String>(){

            public void apply(String string) {
                System.out.println("### >> This is handled async: " + string);
            }
        });
        try {
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void easyProtobufRpc() {
        ActorRef actorRef = AMQP.newConnection();
        String string = "easy.protobuf.rpc";
        RPC.newProtobufRpcServer(actorRef, string, new Function<AkkaAmqp.TestMessage, AkkaAmqp.TestMessage>(){

            public AkkaAmqp.TestMessage apply(AkkaAmqp.TestMessage testMessage) {
                return AkkaAmqp.TestMessage.newBuilder().setMessage(testMessage.getMessage()).build();
            }
        }, AkkaAmqp.TestMessage.class);
        RPC.RpcClient<AkkaAmqp.TestMessage, AkkaAmqp.TestMessage> rpcClient = RPC.newProtobufRpcClient(actorRef, string, AkkaAmqp.TestMessage.class);
        Option<AkkaAmqp.TestMessage> option = rpcClient.call(AkkaAmqp.TestMessage.newBuilder().setMessage("akka-amqp rocks!").build());
        System.out.println("### >> Got response: " + option);
    }
}

