/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.MultiTermQuery;

public class QueryParserSettings {
    private String queryString;
    private String defaultField;
    private float boost = 1.0f;
    private QueryParser.Operator defaultOperator = QueryParser.Operator.OR;
    private boolean autoGeneratePhraseQueries = false;
    private boolean allowLeadingWildcard = true;
    private boolean lowercaseExpandedTerms = true;
    private boolean enablePositionIncrements = true;
    private int phraseSlop = 0;
    private float fuzzyMinSim = 0.5f;
    private int fuzzyPrefixLength = 0;
    private boolean analyzeWildcard = false;
    private boolean escape = false;
    private Analyzer analyzer = null;
    private MultiTermQuery.RewriteMethod rewriteMethod = MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;

    public String queryString() {
        return this.queryString;
    }

    public void queryString(String queryString) {
        this.queryString = queryString;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public void defaultField(String defaultField) {
        this.defaultField = defaultField;
    }

    public float boost() {
        return this.boost;
    }

    public void boost(float boost) {
        this.boost = boost;
    }

    public QueryParser.Operator defaultOperator() {
        return this.defaultOperator;
    }

    public void defaultOperator(QueryParser.Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public boolean autoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public void autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
    }

    public boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void allowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public boolean lowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    public void lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public int phraseSlop() {
        return this.phraseSlop;
    }

    public void phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public float fuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void fuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public int fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public boolean escape() {
        return this.escape;
    }

    public void escape(boolean escape) {
        this.escape = escape;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public void analyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    public void analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
    }

    public MultiTermQuery.RewriteMethod rewriteMethod() {
        return this.rewriteMethod;
    }

    public void rewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParserSettings that = (QueryParserSettings)o;
        if (this.autoGeneratePhraseQueries != that.autoGeneratePhraseQueries()) {
            return false;
        }
        if (this.allowLeadingWildcard != that.allowLeadingWildcard) {
            return false;
        }
        if (Float.compare(that.boost, this.boost) != 0) {
            return false;
        }
        if (this.enablePositionIncrements != that.enablePositionIncrements) {
            return false;
        }
        if (this.escape != that.escape) {
            return false;
        }
        if (this.analyzeWildcard != that.analyzeWildcard) {
            return false;
        }
        if (Float.compare(that.fuzzyMinSim, this.fuzzyMinSim) != 0) {
            return false;
        }
        if (this.fuzzyPrefixLength != that.fuzzyPrefixLength) {
            return false;
        }
        if (this.lowercaseExpandedTerms != that.lowercaseExpandedTerms) {
            return false;
        }
        if (this.phraseSlop != that.phraseSlop) {
            return false;
        }
        if (this.analyzer != null ? !this.analyzer.equals(that.analyzer) : that.analyzer != null) {
            return false;
        }
        if (this.defaultField != null ? !this.defaultField.equals(that.defaultField) : that.defaultField != null) {
            return false;
        }
        if (this.defaultOperator != that.defaultOperator) {
            return false;
        }
        return !(this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null);
    }

    public int hashCode() {
        int result = this.queryString != null ? this.queryString.hashCode() : 0;
        result = 31 * result + (this.defaultField != null ? this.defaultField.hashCode() : 0);
        result = 31 * result + (this.boost != 0.0f ? Float.floatToIntBits(this.boost) : 0);
        result = 31 * result + (this.defaultOperator != null ? this.defaultOperator.hashCode() : 0);
        result = 31 * result + (this.autoGeneratePhraseQueries ? 1 : 0);
        result = 31 * result + (this.allowLeadingWildcard ? 1 : 0);
        result = 31 * result + (this.lowercaseExpandedTerms ? 1 : 0);
        result = 31 * result + (this.enablePositionIncrements ? 1 : 0);
        result = 31 * result + this.phraseSlop;
        result = 31 * result + (this.fuzzyMinSim != 0.0f ? Float.floatToIntBits(this.fuzzyMinSim) : 0);
        result = 31 * result + this.fuzzyPrefixLength;
        result = 31 * result + (this.escape ? 1 : 0);
        result = 31 * result + (this.analyzer != null ? this.analyzer.hashCode() : 0);
        result = 31 * result + (this.analyzeWildcard ? 1 : 0);
        return result;
    }
}

