/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;

public class MarginFragListBuilder
implements FragListBuilder {
    private static final int DEFAULT_MARGIN = 6;
    private int margin;
    private int minFragCharSize;

    public MarginFragListBuilder() {
        this(6);
    }

    public MarginFragListBuilder(int startMargin) {
        this.margin = startMargin;
        this.minFragCharSize = 3 * this.margin;
    }

    public FieldFragList createFieldFragList(FieldPhraseList fieldPhraseList, int fragCharSize) {
        if (fragCharSize < this.minFragCharSize) {
            throw new IllegalArgumentException("fragCharSize(" + fragCharSize + ") is too small. It must be " + this.minFragCharSize + " or higher.");
        }
        FieldFragList ffl = new FieldFragList(fragCharSize);
        ArrayList<FieldPhraseList.WeightedPhraseInfo> wpil = new ArrayList<FieldPhraseList.WeightedPhraseInfo>();
        Iterator ite = fieldPhraseList.phraseList.iterator();
        FieldPhraseList.WeightedPhraseInfo phraseInfo = null;
        int startOffset = 0;
        boolean taken = false;
        while (true) {
            if (!taken) {
                if (!ite.hasNext()) break;
                phraseInfo = (FieldPhraseList.WeightedPhraseInfo)ite.next();
            }
            taken = false;
            if (phraseInfo == null) break;
            if (phraseInfo.getStartOffset() < startOffset) continue;
            wpil.clear();
            wpil.add(phraseInfo);
            int st = phraseInfo.getStartOffset() - this.margin < startOffset ? startOffset : phraseInfo.getStartOffset() - this.margin;
            int en = st + fragCharSize;
            if (phraseInfo.getEndOffset() > en) {
                en = phraseInfo.getEndOffset();
            }
            startOffset = en;
            while (ite.hasNext()) {
                phraseInfo = (FieldPhraseList.WeightedPhraseInfo)ite.next();
                taken = true;
                if (phraseInfo == null || phraseInfo.getEndOffset() > en) break;
                wpil.add(phraseInfo);
            }
            ffl.add(st, en, wpil);
        }
        return ffl;
    }
}

