/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;
import org.apache.lucene.store.bytebuffer.ByteBufferIndexInput;
import org.apache.lucene.store.bytebuffer.ByteBufferIndexOutput;
import org.apache.lucene.store.bytebuffer.PlainByteBufferAllocator;

public class ByteBufferDirectory
extends Directory {
    protected final Map<String, ByteBufferFile> files = new ConcurrentHashMap<String, ByteBufferFile>();
    private final ByteBufferAllocator allocator;
    private final boolean internalAllocator;

    public ByteBufferDirectory() {
        this.allocator = new PlainByteBufferAllocator(false, 1024, 10240);
        this.internalAllocator = true;
        try {
            this.setLockFactory((LockFactory)new SingleInstanceLockFactory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteBufferDirectory(ByteBufferAllocator allocator) {
        this.allocator = allocator;
        this.internalAllocator = false;
        try {
            this.setLockFactory((LockFactory)new SingleInstanceLockFactory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sync(Collection<String> names) throws IOException {
    }

    public String[] listAll() throws IOException {
        return this.files.keySet().toArray(new String[0]);
    }

    public boolean fileExists(String name) throws IOException {
        return this.files.containsKey(name);
    }

    public long fileModified(String name) throws IOException {
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    public void touchFile(String name) throws IOException {
        long ts2;
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    public void deleteFile(String name) throws IOException {
        ByteBufferFile file = this.files.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        file.clean();
    }

    public long fileLength(String name) throws IOException {
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public IndexOutput createOutput(String name) throws IOException {
        ByteBufferFile file;
        ByteBufferFile existing;
        ByteBufferAllocator.Type allocatorType = ByteBufferAllocator.Type.LARGE;
        if (name.contains("segments") || name.endsWith(".del")) {
            allocatorType = ByteBufferAllocator.Type.SMALL;
        }
        if ((existing = this.files.put(name, file = new ByteBufferFile(this, this.allocator.sizeInBytes(allocatorType)))) != null) {
            existing.clean();
        }
        return new ByteBufferIndexOutput(this.allocator, allocatorType, file);
    }

    public IndexInput openInput(String name) throws IOException {
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new ByteBufferIndexInput(file);
    }

    public void close() throws IOException {
        String[] files;
        for (String file : files = this.listAll()) {
            this.deleteFile(file);
        }
        if (this.internalAllocator) {
            this.allocator.close();
        }
    }

    void releaseBuffer(ByteBuffer byteBuffer) {
        this.allocator.release(byteBuffer);
    }
}

