/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesInfoAction
extends TransportNodesOperationAction<NodesInfoRequest, NodesInfoResponse, NodeInfoRequest, NodeInfo> {
    private final MonitorService monitorService;
    private volatile ImmutableMap<String, String> nodeAttributes = ImmutableMap.of();
    @Nullable
    private HttpServer httpServer;

    @Inject
    public TransportNodesInfoAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, MonitorService monitorService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
        this.monitorService = monitorService;
    }

    public void setHttpServer(@Nullable HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    public synchronized void putNodeAttribute(String key, String value) {
        this.nodeAttributes = new MapBuilder<String, String>().putAll(this.nodeAttributes).put(key, value).immutableMap();
    }

    public synchronized void removeNodeAttribute(String key) {
        this.nodeAttributes = new MapBuilder<String, String>().putAll(this.nodeAttributes).remove(key).immutableMap();
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/cluster/nodes/info";
    }

    @Override
    protected String transportNodeAction() {
        return "/cluster/nodes/info/node";
    }

    @Override
    protected NodesInfoResponse newResponse(NodesInfoRequest nodesInfoRequest, AtomicReferenceArray responses) {
        ArrayList<NodeInfo> nodesInfos = new ArrayList<NodeInfo>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeInfo)) continue;
            nodesInfos.add((NodeInfo)resp);
        }
        return new NodesInfoResponse(this.clusterName, nodesInfos.toArray(new NodeInfo[nodesInfos.size()]));
    }

    @Override
    protected NodesInfoRequest newRequest() {
        return new NodesInfoRequest();
    }

    @Override
    protected NodeInfoRequest newNodeRequest() {
        return new NodeInfoRequest();
    }

    @Override
    protected NodeInfoRequest newNodeRequest(String nodeId, NodesInfoRequest request) {
        return new NodeInfoRequest(nodeId);
    }

    @Override
    protected NodeInfo newNodeResponse() {
        return new NodeInfo();
    }

    @Override
    protected NodeInfo nodeOperation(NodeInfoRequest nodeInfoRequest) throws ElasticSearchException {
        return new NodeInfo(this.clusterService.state().nodes().localNode(), this.nodeAttributes, this.settings, this.monitorService.osService().info(), this.monitorService.processService().info(), this.monitorService.jvmService().info(), this.monitorService.networkService().info(), this.transportService.info(), this.httpServer == null ? null : this.httpServer.info());
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    protected static class NodeInfoRequest
    extends NodeOperationRequest {
        private NodeInfoRequest() {
        }

        private NodeInfoRequest(String nodeId) {
            super(nodeId);
        }
    }
}

