/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesStatsAction
extends TransportNodesOperationAction<NodesStatsRequest, NodesStatsResponse, NodeStatsRequest, NodeStats> {
    private final MonitorService monitorService;
    private final IndicesService indicesService;
    @Nullable
    private HttpServer httpServer;

    @Inject
    public TransportNodesStatsAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, MonitorService monitorService, IndicesService indicesService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
        this.monitorService = monitorService;
        this.indicesService = indicesService;
    }

    public void setHttpServer(@Nullable HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/cluster/nodes/stats";
    }

    @Override
    protected String transportNodeAction() {
        return "/cluster/nodes/stats/node";
    }

    @Override
    protected NodesStatsResponse newResponse(NodesStatsRequest nodesInfoRequest, AtomicReferenceArray responses) {
        ArrayList<NodeStats> nodeStats = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeStats)) continue;
            nodeStats.add((NodeStats)resp);
        }
        return new NodesStatsResponse(this.clusterName, nodeStats.toArray(new NodeStats[nodeStats.size()]));
    }

    @Override
    protected NodesStatsRequest newRequest() {
        return new NodesStatsRequest();
    }

    @Override
    protected NodeStatsRequest newNodeRequest() {
        return new NodeStatsRequest();
    }

    @Override
    protected NodeStatsRequest newNodeRequest(String nodeId, NodesStatsRequest request) {
        return new NodeStatsRequest(nodeId);
    }

    @Override
    protected NodeStats newNodeResponse() {
        return new NodeStats();
    }

    @Override
    protected NodeStats nodeOperation(NodeStatsRequest request) throws ElasticSearchException {
        return new NodeStats(this.clusterService.state().nodes().localNode(), this.indicesService.stats(), this.monitorService.osService().stats(), this.monitorService.processService().stats(), this.monitorService.jvmService().stats(), this.monitorService.networkService().stats(), this.transportService.stats(), this.httpServer == null ? null : this.httpServer.stats());
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    protected static class NodeStatsRequest
    extends NodeOperationRequest {
        private NodeStatsRequest() {
        }

        private NodeStatsRequest(String nodeId) {
            super(nodeId);
        }
    }
}

