/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.replication;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.admin.cluster.ping.replication.IndexReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.IndexReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.ReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.ReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.TransportIndexReplicationPingAction;
import org.elasticsearch.action.support.replication.TransportIndicesReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportReplicationPingAction
extends TransportIndicesReplicationOperationAction<ReplicationPingRequest, ReplicationPingResponse, IndexReplicationPingRequest, IndexReplicationPingResponse, ShardReplicationPingRequest, ShardReplicationPingResponse> {
    @Inject
    public TransportReplicationPingAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportIndexReplicationPingAction indexAction) {
        super(settings, transportService, clusterService, threadPool, indexAction);
    }

    @Override
    protected ReplicationPingRequest newRequestInstance() {
        return new ReplicationPingRequest();
    }

    @Override
    protected ReplicationPingResponse newResponseInstance(ReplicationPingRequest request, AtomicReferenceArray indexResponses) {
        ReplicationPingResponse response = new ReplicationPingResponse();
        for (int i = 0; i < indexResponses.length(); ++i) {
            IndexReplicationPingResponse indexResponse = (IndexReplicationPingResponse)indexResponses.get(i);
            if (indexResponse == null) continue;
            response.indices().put(indexResponse.index(), indexResponse);
        }
        return response;
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    @Override
    protected String transportAction() {
        return "/cluster/ping/replication";
    }

    @Override
    protected IndexReplicationPingRequest newIndexRequestInstance(ReplicationPingRequest request, String index, Set<String> routing) {
        return new IndexReplicationPingRequest(request, index);
    }
}

