/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;

public class IndicesAliasesRequest
extends MasterNodeOperationRequest {
    private List<AliasAction> aliasActions = Lists.newArrayList();
    private TimeValue timeout = TimeValue.timeValueSeconds(10L);

    public IndicesAliasesRequest addAlias(String index, String alias) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
        return this;
    }

    public IndicesAliasesRequest addAlias(String index, String alias, String filter) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias, filter));
        return this;
    }

    public IndicesAliasesRequest addAlias(String index, String alias, Map<String, Object> filter) {
        if (filter == null || filter.isEmpty()) {
            this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter);
            this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias, builder.string()));
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public IndicesAliasesRequest addAlias(String index, String alias, FilterBuilder filterBuilder) {
        if (filterBuilder == null) {
            this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            filterBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            return this.addAlias(index, alias, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to build json for alias request", e);
        }
    }

    public IndicesAliasesRequest removeAlias(String index, String alias) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.REMOVE, index, alias));
        return this;
    }

    public IndicesAliasesRequest addAliasAction(AliasAction action) {
        this.aliasActions.add(action);
        return this;
    }

    List<AliasAction> aliasActions() {
        return this.aliasActions;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public IndicesAliasesRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public IndicesAliasesRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, TimeValue.timeValueSeconds(10L)));
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.aliasActions.isEmpty()) {
            validationException = Actions.addValidationError("Must specify at least one alias action", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.aliasActions.add(AliasAction.readAliasAction(in));
        }
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.aliasActions.size());
        for (AliasAction aliasAction : this.aliasActions) {
            aliasAction.writeTo(out);
        }
        this.timeout.writeTo(out);
    }
}

