/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.support.single.custom.TransportSingleCustomOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAnalyzeAction
extends TransportSingleCustomOperationAction<AnalyzeRequest, AnalyzeResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportAnalyzeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected AnalyzeRequest newRequest() {
        return new AnalyzeRequest();
    }

    @Override
    protected AnalyzeResponse newResponse() {
        return new AnalyzeResponse();
    }

    @Override
    protected String transportAction() {
        return "indices/analyze";
    }

    @Override
    protected String transportShardAction() {
        return "indices/analyze/shard";
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, AnalyzeRequest request) {
        request.index(clusterState.metaData().concreteIndex(request.index()));
        return clusterState.routingTable().index(request.index()).randomAllActiveShardsIt();
    }

    @Override
    protected AnalyzeResponse shardOperation(AnalyzeRequest request, int shardId) throws ElasticSearchException {
        FieldMapper fieldMapper;
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        NamedAnalyzer analyzer = null;
        String field = null;
        if (request.field() != null && (fieldMapper = indexService.mapperService().smartNameFieldMapper(request.field())) != null) {
            analyzer = fieldMapper.indexAnalyzer();
            field = fieldMapper.names().indexName();
        }
        if (field == null) {
            field = "_all";
        }
        if (analyzer == null && request.analyzer() != null) {
            analyzer = indexService.analysisService().analyzer(request.analyzer());
        } else if (analyzer == null) {
            analyzer = indexService.analysisService().defaultIndexAnalyzer();
        }
        if (analyzer == null) {
            throw new ElasticSearchIllegalArgumentException("failed to find analyzer");
        }
        ArrayList<AnalyzeResponse.AnalyzeToken> tokens = Lists.newArrayList();
        TokenStream stream = null;
        try {
            stream = analyzer.reusableTokenStream(field, new FastStringReader(request.text()));
            stream.reset();
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posIncr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offset = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            TypeAttribute type = (TypeAttribute)stream.addAttribute(TypeAttribute.class);
            int position = 0;
            while (stream.incrementToken()) {
                int increment = posIncr.getPositionIncrement();
                if (increment > 0) {
                    position += increment;
                }
                tokens.add(new AnalyzeResponse.AnalyzeToken(term.toString(), position, offset.startOffset(), offset.endOffset(), type.type()));
            }
            stream.end();
        }
        catch (IOException e) {
            throw new ElasticSearchException("failed to analyze", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return new AnalyzeResponse(tokens);
    }
}

