/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.engine.Segment;

public class IndicesSegmentResponse
extends BroadcastOperationResponse
implements ToXContent {
    private ShardSegments[] shards;
    private Map<String, IndexSegments> indicesSegments;

    IndicesSegmentResponse() {
    }

    IndicesSegmentResponse(ShardSegments[] shards, ClusterState clusterState, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public Map<String, IndexSegments> getIndices() {
        return this.indices();
    }

    public Map<String, IndexSegments> indices() {
        if (this.indicesSegments != null) {
            return this.indicesSegments;
        }
        HashMap<String, IndexSegments> indicesSegments = Maps.newHashMap();
        HashSet<String> indices = Sets.newHashSet();
        for (ShardSegments shard : this.shards) {
            indices.add(shard.index());
        }
        for (String index : indices) {
            ArrayList<ShardSegments> shards = Lists.newArrayList();
            for (ShardSegments shard : this.shards) {
                if (!shard.shardRouting().index().equals(index)) continue;
                shards.add(shard);
            }
            indicesSegments.put(index, new IndexSegments(index, shards.toArray(new ShardSegments[shards.size()])));
        }
        this.indicesSegments = indicesSegments;
        return indicesSegments;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shards = new ShardSegments[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = ShardSegments.readShardSegments(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shards.length);
        for (ShardSegments shard : this.shards) {
            shard.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.INDICES);
        for (IndexSegments indexSegments : this.indices().values()) {
            builder.startObject(indexSegments.index(), XContentBuilder.FieldCaseConversion.NONE);
            builder.startObject(Fields.SHARDS);
            for (IndexShardSegments indexSegment : indexSegments) {
                builder.startArray(Integer.toString(indexSegment.shardId().id()));
                for (ShardSegments shardSegments : indexSegment) {
                    builder.startObject();
                    builder.startObject(Fields.ROUTING);
                    builder.field(Fields.STATE, (Object)shardSegments.shardRouting().state());
                    builder.field(Fields.PRIMARY, shardSegments.shardRouting().primary());
                    builder.field(Fields.NODE, shardSegments.shardRouting().currentNodeId());
                    if (shardSegments.shardRouting().relocatingNodeId() != null) {
                        builder.field(Fields.RELOCATING_NODE, shardSegments.shardRouting().relocatingNodeId());
                    }
                    builder.endObject();
                    builder.startObject(Fields.SEGMENTS);
                    for (Segment segment : shardSegments) {
                        builder.startObject(segment.name());
                        builder.field(Fields.GENERATION, segment.generation());
                        builder.field(Fields.NUM_DOCS, segment.numDocs());
                        builder.field(Fields.DELETED_DOCS, segment.deletedDocs());
                        builder.field(Fields.SIZE, segment.size().toString());
                        builder.field(Fields.SIZE_IN_BYTES, segment.sizeInBytes());
                        builder.field(Fields.COMMITTED, segment.committed());
                        builder.field(Fields.SEARCH, segment.search());
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString ROUTING = new XContentBuilderString("routing");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString NODE = new XContentBuilderString("node");
        static final XContentBuilderString RELOCATING_NODE = new XContentBuilderString("relocating_node");
        static final XContentBuilderString SEGMENTS = new XContentBuilderString("segments");
        static final XContentBuilderString GENERATION = new XContentBuilderString("generation");
        static final XContentBuilderString NUM_DOCS = new XContentBuilderString("num_docs");
        static final XContentBuilderString DELETED_DOCS = new XContentBuilderString("deleted_docs");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
        static final XContentBuilderString COMMITTED = new XContentBuilderString("committed");
        static final XContentBuilderString SEARCH = new XContentBuilderString("search");

        Fields() {
        }
    }
}

