/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.set.hash.THashSet;

public class ShardDeleteByQueryRequest
extends ShardReplicationOperationRequest {
    private int shardId;
    private byte[] querySource;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private Set<String> routing;
    @Nullable
    private String[] filteringAliases;

    ShardDeleteByQueryRequest(IndexDeleteByQueryRequest request, int shardId) {
        this.index = request.index();
        this.querySource = request.querySource();
        this.types = request.types();
        this.shardId = shardId;
        this.replicationType(request.replicationType());
        this.consistencyLevel(request.consistencyLevel());
        this.timeout = request.timeout();
        this.routing = request.routing();
        this.filteringAliases = request.filteringAliases();
    }

    ShardDeleteByQueryRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            Actions.addValidationError("querySource is missing", validationException);
        }
        return validationException;
    }

    public int shardId() {
        return this.shardId;
    }

    public byte[] querySource() {
        return this.querySource;
    }

    public String[] types() {
        return this.types;
    }

    public Set<String> routing() {
        return this.routing;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        int routingSize;
        super.readFrom(in);
        this.querySource = new byte[in.readVInt()];
        in.readFully(this.querySource);
        this.shardId = in.readVInt();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        if ((routingSize = in.readVInt()) > 0) {
            this.routing = new THashSet<String>(routingSize);
            for (int i = 0; i < routingSize; ++i) {
                this.routing.add(in.readUTF());
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.querySource.length);
        out.writeBytes(this.querySource);
        out.writeVInt(this.shardId);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        if (this.routing != null) {
            out.writeVInt(this.routing.size());
            for (String r : this.routing) {
                out.writeUTF(r);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeUTF(alias);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = Unicode.fromBytes(this.querySource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "delete_by_query {[" + this.index + "]" + Arrays.toString(this.types) + ", query [" + sSource + "]}";
    }
}

