/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.get.TransportShardMultiGetAction;
import org.elasticsearch.action.support.BaseAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportMultiGetAction
extends BaseAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;

    @Inject
    public TransportMultiGetAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        transportService.registerHandler("indices/mget", new TransportHandler());
    }

    @Override
    protected void doExecute(MultiGetRequest request, final ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.items.size(); ++i) {
            MultiGetRequest.Item item = request.items.get(i);
            item.index(clusterState.metaData().concreteIndex(item.index()));
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, item.index(), item.type(), item.id(), item.routing(), null).shardId();
            final MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiGetShardRequest(shardId.index().name(), shardId.id());
                shardRequest.preference(request.preference);
                shardRequest.realtime(request.realtime);
                shardRequest.refresh(request.refresh);
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item.type(), item.id(), item.fields());
        }
        final MultiGetItemResponse[] responses = new MultiGetItemResponse[request.items.size()];
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiGetShardResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(MultiGetShardResponse response) {
                    MultiGetItemResponse[] multiGetItemResponseArray = responses;
                    synchronized (responses) {
                        for (int i = 0; i < response.locations.size(); ++i) {
                            responses[response.locations.get((int)i)] = new MultiGetItemResponse(response.responses.get(i), response.failures.get(i));
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable e) {
                    String message = ExceptionsHelper.detailedMessage(e);
                    MultiGetItemResponse[] multiGetItemResponseArray = responses;
                    synchronized (responses) {
                        for (int i = 0; i < shardRequest.locations.size(); ++i) {
                            responses[shardRequest.locations.get((int)i)] = new MultiGetItemResponse(null, new MultiGetResponse.Failure(shardRequest.index(), shardRequest.types.get(i), shardRequest.ids.get(i), message));
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                        return;
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiGetResponse(responses));
                }
            });
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<MultiGetRequest> {
        TransportHandler() {
        }

        @Override
        public MultiGetRequest newInstance() {
            return new MultiGetRequest();
        }

        @Override
        public void messageReceived(final MultiGetRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportMultiGetAction.this.execute(request, new ActionListener<MultiGetResponse>(){

                @Override
                public void onResponse(MultiGetResponse response) {
                    try {
                        channel.sendResponse(response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMultiGetAction.this.logger.warn("Failed to send error response for action [indices/mget] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

