/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.mlt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class MoreLikeThisRequest
implements ActionRequest {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private String index;
    private String type;
    private String id;
    private String[] fields;
    private float percentTermsToMatch = -1.0f;
    private int minTermFreq = -1;
    private int maxQueryTerms = -1;
    private String[] stopWords = null;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLen = -1;
    private int maxWordLen = -1;
    private float boostTerms = -1.0f;
    private SearchType searchType = SearchType.DEFAULT;
    private int searchSize = 0;
    private int searchFrom = 0;
    private String searchQueryHint;
    private String[] searchIndices;
    private String[] searchTypes;
    private Scroll searchScroll;
    private byte[] searchSource;
    private int searchSourceOffset;
    private int searchSourceLength;
    private boolean searchSourceUnsafe;
    private boolean threadedListener = false;

    MoreLikeThisRequest() {
    }

    public MoreLikeThisRequest(String index) {
        this.index = index;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    void index(String index) {
        this.index = index;
    }

    @Required
    public MoreLikeThisRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    @Required
    public MoreLikeThisRequest id(String id) {
        this.id = id;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public MoreLikeThisRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public MoreLikeThisRequest percentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
        return this;
    }

    public float percentTermsToMatch() {
        return this.percentTermsToMatch;
    }

    public MoreLikeThisRequest minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public int minTermFreq() {
        return this.minTermFreq;
    }

    public MoreLikeThisRequest maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public int maxQueryTerms() {
        return this.maxQueryTerms;
    }

    public MoreLikeThisRequest stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public String[] stopWords() {
        return this.stopWords;
    }

    public MoreLikeThisRequest minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public MoreLikeThisRequest maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public int maxDocFreq() {
        return this.maxDocFreq;
    }

    public MoreLikeThisRequest minWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
        return this;
    }

    public int minWordLen() {
        return this.minWordLen;
    }

    public MoreLikeThisRequest maxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
        return this;
    }

    public int maxWordLen() {
        return this.maxWordLen;
    }

    public MoreLikeThisRequest boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public float boostTerms() {
        return this.boostTerms;
    }

    void beforeLocalFork() {
        if (this.searchSourceUnsafe) {
            this.searchSource = Arrays.copyOfRange(this.searchSource, this.searchSourceOffset, this.searchSourceOffset + this.searchSourceLength);
            this.searchSourceOffset = 0;
            this.searchSourceUnsafe = false;
        }
    }

    public MoreLikeThisRequest searchSource(SearchSourceBuilder sourceBuilder) {
        BytesStream bos = sourceBuilder.buildAsUnsafeBytes(Requests.CONTENT_TYPE);
        this.searchSource = bos.unsafeByteArray();
        this.searchSourceOffset = 0;
        this.searchSourceLength = bos.size();
        this.searchSourceUnsafe = true;
        return this;
    }

    public MoreLikeThisRequest searchSource(String searchSource) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(searchSource);
        this.searchSource = result.result;
        this.searchSourceOffset = 0;
        this.searchSourceLength = result.length;
        this.searchSourceUnsafe = true;
        return this;
    }

    public MoreLikeThisRequest searchSource(Map searchSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(searchSource);
            return this.searchSource(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + searchSource + "]", e);
        }
    }

    public MoreLikeThisRequest searchSource(XContentBuilder builder) {
        try {
            this.searchSource = builder.unsafeBytes();
            this.searchSourceOffset = 0;
            this.searchSourceLength = builder.unsafeBytesLength();
            this.searchSourceUnsafe = true;
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + builder + "]", e);
        }
    }

    public MoreLikeThisRequest searchSource(byte[] searchSource) {
        return this.searchSource(searchSource, 0, searchSource.length, false);
    }

    public MoreLikeThisRequest searchSource(byte[] searchSource, int offset, int length, boolean unsafe) {
        this.searchSource = searchSource;
        this.searchSourceOffset = offset;
        this.searchSourceLength = length;
        this.searchSourceUnsafe = unsafe;
        return this;
    }

    public byte[] searchSource() {
        return this.searchSource;
    }

    public int searchSourceOffset() {
        return this.searchSourceOffset;
    }

    public int searchSourceLength() {
        return this.searchSourceLength;
    }

    public boolean searchSourceUnsafe() {
        return this.searchSourceUnsafe;
    }

    public MoreLikeThisRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public MoreLikeThisRequest searchType(String searchType) throws ElasticSearchIllegalArgumentException {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public MoreLikeThisRequest searchIndices(String ... searchIndices) {
        this.searchIndices = searchIndices;
        return this;
    }

    public String[] searchIndices() {
        return this.searchIndices;
    }

    public MoreLikeThisRequest searchTypes(String ... searchTypes) {
        this.searchTypes = searchTypes;
        return this;
    }

    public String[] searchTypes() {
        return this.searchTypes;
    }

    public MoreLikeThisRequest searchQueryHint(String searchQueryHint) {
        this.searchQueryHint = searchQueryHint;
        return this;
    }

    public String searchQueryHint() {
        return this.searchQueryHint;
    }

    public MoreLikeThisRequest searchScroll(Scroll searchScroll) {
        this.searchScroll = searchScroll;
        return this;
    }

    public Scroll searchScroll() {
        return this.searchScroll;
    }

    public MoreLikeThisRequest searchSize(int size) {
        this.searchSize = size;
        return this;
    }

    public int searchSize() {
        return this.searchSize;
    }

    public MoreLikeThisRequest searchFrom(int from) {
        this.searchFrom = from;
        return this;
    }

    public int searchFrom() {
        return this.searchFrom;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = Actions.addValidationError("index is missing", validationException);
        }
        if (this.type == null) {
            validationException = Actions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = Actions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    @Override
    public boolean listenerThreaded() {
        return this.threadedListener;
    }

    @Override
    public ActionRequest listenerThreaded(boolean listenerThreaded) {
        this.threadedListener = listenerThreaded;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.index = in.readUTF();
        this.type = in.readUTF();
        this.id = in.readUTF();
        int size = in.readVInt();
        if (size == 0) {
            this.fields = Strings.EMPTY_ARRAY;
        } else {
            this.fields = new String[size];
            for (i = 0; i < size; ++i) {
                this.fields[i] = in.readUTF();
            }
        }
        this.percentTermsToMatch = in.readFloat();
        this.minTermFreq = in.readVInt();
        this.maxQueryTerms = in.readVInt();
        size = in.readVInt();
        if (size > 0) {
            this.stopWords = new String[size];
            for (i = 0; i < size; ++i) {
                this.stopWords[i] = in.readUTF();
            }
        }
        this.minDocFreq = in.readVInt();
        this.maxDocFreq = in.readVInt();
        this.minWordLen = in.readVInt();
        this.maxWordLen = in.readVInt();
        this.boostTerms = in.readFloat();
        this.searchType = SearchType.fromId(in.readByte());
        if (in.readBoolean()) {
            this.searchQueryHint = in.readUTF();
        }
        if ((size = in.readVInt()) == 0) {
            this.searchIndices = null;
        } else if (size == 1) {
            this.searchIndices = Strings.EMPTY_ARRAY;
        } else {
            this.searchIndices = new String[size - 1];
            for (i = 0; i < this.searchIndices.length; ++i) {
                this.searchIndices[i] = in.readUTF();
            }
        }
        size = in.readVInt();
        if (size == 0) {
            this.searchTypes = null;
        } else if (size == 1) {
            this.searchTypes = Strings.EMPTY_ARRAY;
        } else {
            this.searchTypes = new String[size - 1];
            for (i = 0; i < this.searchTypes.length; ++i) {
                this.searchTypes[i] = in.readUTF();
            }
        }
        if (in.readBoolean()) {
            this.searchScroll = Scroll.readScroll(in);
        }
        this.searchSourceUnsafe = false;
        this.searchSourceOffset = 0;
        this.searchSourceLength = in.readVInt();
        if (this.searchSourceLength == 0) {
            this.searchSource = Bytes.EMPTY_ARRAY;
        } else {
            this.searchSource = new byte[this.searchSourceLength];
            in.readFully(this.searchSource);
        }
        this.searchSize = in.readVInt();
        this.searchFrom = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeUTF(this.type);
        out.writeUTF(this.id);
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.length);
            for (String field : this.fields) {
                out.writeUTF(field);
            }
        }
        out.writeFloat(this.percentTermsToMatch);
        out.writeVInt(this.minTermFreq);
        out.writeVInt(this.maxQueryTerms);
        if (this.stopWords == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.stopWords.length);
            for (String stopWord : this.stopWords) {
                out.writeUTF(stopWord);
            }
        }
        out.writeVInt(this.minDocFreq);
        out.writeVInt(this.maxDocFreq);
        out.writeVInt(this.minWordLen);
        out.writeVInt(this.maxWordLen);
        out.writeFloat(this.boostTerms);
        out.writeByte(this.searchType.id());
        if (this.searchQueryHint == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.searchQueryHint);
        }
        if (this.searchIndices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.searchIndices.length + 1);
            for (String index : this.searchIndices) {
                out.writeUTF(index);
            }
        }
        if (this.searchTypes == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.searchTypes.length + 1);
            for (String type : this.searchTypes) {
                out.writeUTF(type);
            }
        }
        if (this.searchScroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.searchScroll.writeTo(out);
        }
        if (this.searchSource == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.searchSourceLength);
            out.writeBytes(this.searchSource, this.searchSourceOffset, this.searchSourceLength);
        }
        out.writeVInt(this.searchSize);
        out.writeVInt(this.searchFrom);
    }
}

