/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTIntArrayList;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchDfsQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchDfsQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache transportSearchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, transportSearchCache, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<DfsSearchResult> {
        private final Collection<DfsSearchResult> dfsResults;
        private final Map<SearchShardTarget, QuerySearchResultProvider> queryResults;
        private final Map<SearchShardTarget, FetchSearchResult> fetchResults;
        private volatile Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchDfsQueryThenFetchAction.this, request, listener);
            this.dfsResults = TransportSearchDfsQueryThenFetchAction.this.searchCache.obtainDfsResults();
            this.queryResults = TransportSearchDfsQueryThenFetchAction.this.searchCache.obtainQueryResults();
            this.fetchResults = TransportSearchDfsQueryThenFetchAction.this.searchCache.obtainFetchResults();
        }

        @Override
        protected String firstPhaseName() {
            return "dfs";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, InternalSearchRequest request, SearchServiceListener<DfsSearchResult> listener) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteDfs(node, request, listener);
        }

        @Override
        protected void processFirstPhaseResult(ShardRouting shard, DfsSearchResult result) {
            this.dfsResults.add(result);
        }

        @Override
        protected void moveToSecondPhase() {
            final AggregatedDfs dfs = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.aggregateDfs(this.dfsResults);
            final AtomicInteger counter = new AtomicInteger(this.dfsResults.size());
            int localOperations = 0;
            for (DfsSearchResult dfsResult : this.dfsResults) {
                DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                QuerySearchRequest querySearchRequest = new QuerySearchRequest(dfsResult.id(), dfs);
                this.executeQuery(dfsResult, counter, querySearchRequest, node);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (DfsSearchResult dfsResult : AsyncAction.this.dfsResults) {
                                DiscoveryNode node = AsyncAction.this.nodes.get(dfsResult.shardTarget().nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                QuerySearchRequest querySearchRequest = new QuerySearchRequest(dfsResult.id(), dfs);
                                AsyncAction.this.executeQuery(dfsResult, counter, querySearchRequest, node);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final DfsSearchResult dfsResult : this.dfsResults) {
                        final DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final QuerySearchRequest querySearchRequest = new QuerySearchRequest(dfsResult.id(), dfs);
                        if (localAsync) {
                            TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    AsyncAction.this.executeQuery(dfsResult, counter, querySearchRequest, node);
                                }
                            });
                            continue;
                        }
                        this.executeQuery(dfsResult, counter, querySearchRequest, node);
                    }
                }
            }
        }

        void executeQuery(final DfsSearchResult dfsResult, final AtomicInteger counter, final QuerySearchRequest querySearchRequest, DiscoveryNode node) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteQuery(node, querySearchRequest, new SearchServiceListener<QuerySearchResult>(){

                @Override
                public void onResult(QuerySearchResult result) {
                    result.shardTarget(dfsResult.shardTarget());
                    AsyncAction.this.queryResults.put(result.shardTarget(), result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchDfsQueryThenFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
                    }
                    AsyncAction.this.shardFailures.add(new ShardSearchFailure(t));
                    AsyncAction.this.successulOps.decrementAndGet();
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }
            });
        }

        void executeFetchPhase() {
            try {
                this.innerExecuteFetchPhase();
            }
            catch (Exception e) {
                this.listener.onFailure(new ReduceSearchPhaseException("query", "", e, this.buildShardFailures()));
            }
        }

        void innerExecuteFetchPhase() {
            this.sortedShardList = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.sortDocs(this.queryResults.values());
            final Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.docIdsToLoad(this.sortedShardList);
            this.docIdsToLoad = docIdsToLoad;
            if (docIdsToLoad.isEmpty()) {
                this.finishHim();
                return;
            }
            final AtomicInteger counter = new AtomicInteger(docIdsToLoad.size());
            int localOperations = 0;
            for (Map.Entry<SearchShardTarget, ExtTIntArrayList> entry : docIdsToLoad.entrySet()) {
                DiscoveryNode node = this.nodes.get(entry.getKey().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.queryResults.get(entry.getKey()).id(), entry.getValue());
                this.executeFetch(entry.getKey(), counter, fetchSearchRequest, node);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (Map.Entry entry : docIdsToLoad.entrySet()) {
                                DiscoveryNode node = AsyncAction.this.nodes.get(((SearchShardTarget)entry.getKey()).nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(((QuerySearchResultProvider)AsyncAction.this.queryResults.get(entry.getKey())).id(), (ExtTIntArrayList)entry.getValue());
                                AsyncAction.this.executeFetch((SearchShardTarget)entry.getKey(), counter, fetchSearchRequest, node);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final Map.Entry<SearchShardTarget, ExtTIntArrayList> entry : docIdsToLoad.entrySet()) {
                        final DiscoveryNode node = this.nodes.get(entry.getKey().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.queryResults.get(entry.getKey()).id(), entry.getValue());
                        if (localAsync) {
                            TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    AsyncAction.this.executeFetch((SearchShardTarget)entry.getKey(), counter, fetchSearchRequest, node);
                                }
                            });
                            continue;
                        }
                        this.executeFetch(entry.getKey(), counter, fetchSearchRequest, node);
                    }
                }
            }
        }

        void executeFetch(final SearchShardTarget shardTarget, final AtomicInteger counter, final FetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result) {
                    result.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.put(result.shardTarget(), result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchDfsQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
                    }
                    AsyncAction.this.shardFailures.add(new ShardSearchFailure(t));
                    AsyncAction.this.successulOps.decrementAndGet();
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures());
                if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchDfsQueryThenFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
            finally {
                this.releaseIrrelevantSearchContexts(this.queryResults, this.docIdsToLoad);
                TransportSearchDfsQueryThenFetchAction.this.searchCache.releaseDfsResults(this.dfsResults);
                TransportSearchDfsQueryThenFetchAction.this.searchCache.releaseQueryResults(this.queryResults);
                TransportSearchDfsQueryThenFetchAction.this.searchCache.releaseFetchResults(this.fetchResults);
            }
        }

        void innerFinishHim() throws Exception {
            InternalSearchResponse internalResponse = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), this.dfsResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

