/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.DocumentMapper;

public class MappingMetaData {
    private final String type;
    private final CompressedString source;
    private final Routing routing;

    public MappingMetaData(DocumentMapper docMapper) {
        this.type = docMapper.type();
        this.source = docMapper.mappingSource();
        this.routing = new Routing(docMapper.routingFieldMapper().required(), docMapper.routingFieldMapper().path());
    }

    public MappingMetaData(String type, Map<String, Object> mapping) throws IOException {
        this.type = type;
        this.source = new CompressedString(XContentFactory.jsonBuilder().map(mapping).string());
        Map withoutType = mapping;
        if (mapping.size() == 1 && mapping.containsKey(type)) {
            withoutType = (Map)mapping.get(type);
        }
        if (withoutType.containsKey("_routing")) {
            boolean required = false;
            String path = null;
            Map routingNode = (Map)withoutType.get("_routing");
            for (Map.Entry entry : routingNode.entrySet()) {
                String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("required")) {
                    required = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (!fieldName.equals("path")) continue;
                path = fieldNode.toString();
            }
            this.routing = new Routing(required, path);
        } else {
            this.routing = Routing.EMPTY;
        }
    }

    MappingMetaData(String type, CompressedString source, Routing routing) {
        this.type = type;
        this.source = source;
        this.routing = routing;
    }

    public String type() {
        return this.type;
    }

    public CompressedString source() {
        return this.source;
    }

    public Routing routing() {
        return this.routing;
    }

    public String parseRouting(XContentParser parser) throws IOException {
        return this.parseRouting(parser, 0);
    }

    private String parseRouting(XContentParser parser, int location) throws IOException {
        XContentParser.Token t = parser.currentToken();
        if (t == null) {
            t = parser.nextToken();
        }
        if (t == XContentParser.Token.START_OBJECT) {
            t = parser.nextToken();
        }
        String routingPart = this.routing().pathElements()[location];
        while (t == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            t = parser.nextToken();
            if (routingPart.equals(fieldName)) {
                if (++location == this.routing.pathElements().length) {
                    return parser.textOrNull();
                }
                if (t == XContentParser.Token.START_OBJECT) {
                    return this.parseRouting(parser, location);
                }
            } else {
                parser.skipChildren();
            }
            t = parser.nextToken();
        }
        return null;
    }

    public static void writeTo(MappingMetaData mappingMd, StreamOutput out) throws IOException {
        out.writeUTF(mappingMd.type());
        mappingMd.source().writeTo(out);
        out.writeBoolean(mappingMd.routing().required());
        if (mappingMd.routing().hasPath()) {
            out.writeBoolean(true);
            out.writeUTF(mappingMd.routing().path());
        } else {
            out.writeBoolean(false);
        }
    }

    public static MappingMetaData readFrom(StreamInput in) throws IOException {
        String type = in.readUTF();
        CompressedString source = CompressedString.readCompressedString(in);
        Routing routing = new Routing(in.readBoolean(), in.readBoolean() ? in.readUTF() : null);
        return new MappingMetaData(type, source, routing);
    }

    public static class Routing {
        public static final Routing EMPTY = new Routing(false, null);
        private final boolean required;
        private final String path;
        private final String[] pathElements;

        public Routing(boolean required, String path) {
            this.required = required;
            this.path = path;
            this.pathElements = path == null ? Strings.EMPTY_ARRAY : Strings.delimitedListToStringArray(path, ".");
        }

        public boolean required() {
            return this.required;
        }

        public boolean hasPath() {
            return this.path != null;
        }

        public String path() {
            return this.path;
        }

        public String[] pathElements() {
            return this.pathElements;
        }
    }
}

