/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.common.util.concurrent.Immutable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;

@Immutable
public class MetaData
implements Iterable<IndexMetaData> {
    public static final MetaData EMPTY_META_DATA = MetaData.newMetaDataBuilder().build();
    private final long version;
    private final ImmutableMap<String, IndexMetaData> indices;
    private final ImmutableMap<String, IndexTemplateMetaData> templates;
    private final transient int totalNumberOfShards;
    private final String[] allIndices;
    private final String[] allOpenIndices;
    private final ImmutableMap<String, ImmutableMap<String, AliasMetaData>> aliases;
    private final ImmutableMap<String, ImmutableMap<String, ImmutableSet<String>>> aliasToIndexToSearchRoutingMap;
    private final ImmutableMap<String, ImmutableMap<String, Boolean>> indexToAliasFilteringRequiredMap;
    private final ImmutableMap<String, String[]> aliasAndIndexToIndexMap;

    private MetaData(long version, ImmutableMap<String, IndexMetaData> indices, ImmutableMap<String, IndexTemplateMetaData> templates) {
        this.version = version;
        this.indices = ImmutableMap.copyOf(indices);
        this.templates = templates;
        int totalNumberOfShards = 0;
        for (IndexMetaData indexMetaData : indices.values()) {
            totalNumberOfShards += indexMetaData.totalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        ArrayList<String> allIndicesLst = Lists.newArrayList();
        for (IndexMetaData indexMetaData : indices.values()) {
            allIndicesLst.add(indexMetaData.index());
        }
        this.allIndices = allIndicesLst.toArray(new String[allIndicesLst.size()]);
        ArrayList<String> allOpenIndices = Lists.newArrayList();
        for (IndexMetaData indexMetaData : indices.values()) {
            if (indexMetaData.state() != IndexMetaData.State.OPEN) continue;
            allOpenIndices.add(indexMetaData.index());
        }
        this.allOpenIndices = allOpenIndices.toArray(new String[allOpenIndices.size()]);
        MapBuilder tmpAliasesMap = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices.values()) {
            String index = indexMetaData.index();
            for (AliasMetaData aliasMd : indexMetaData.aliases().values()) {
                MapBuilder<String, AliasMetaData> indexAliasMap = (MapBuilder<String, AliasMetaData>)tmpAliasesMap.get(aliasMd.alias());
                if (indexAliasMap == null) {
                    indexAliasMap = MapBuilder.newMapBuilder();
                    tmpAliasesMap.put(aliasMd.alias(), indexAliasMap);
                }
                indexAliasMap.put(index, aliasMd);
            }
        }
        MapBuilder aliases = MapBuilder.newMapBuilder();
        for (Map.Entry alias : tmpAliasesMap.map().entrySet()) {
            aliases.put(alias.getKey(), ((MapBuilder)alias.getValue()).immutableMap());
        }
        this.aliases = aliases.immutableMap();
        MapBuilder tmpAliasToIndexToSearchRoutingMap = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices.values()) {
            for (AliasMetaData aliasMd : indexMetaData.aliases().values()) {
                MapBuilder indexToSearchRoutingMap = (MapBuilder)tmpAliasToIndexToSearchRoutingMap.get(aliasMd.alias());
                if (indexToSearchRoutingMap == null) {
                    indexToSearchRoutingMap = MapBuilder.newMapBuilder();
                    tmpAliasToIndexToSearchRoutingMap.put(aliasMd.alias(), indexToSearchRoutingMap);
                }
                if (aliasMd.searchRouting() != null) {
                    indexToSearchRoutingMap.put(indexMetaData.index(), ImmutableSet.copyOf(Strings.splitStringByCommaToSet(aliasMd.searchRouting())));
                    continue;
                }
                indexToSearchRoutingMap.put(indexMetaData.index(), ImmutableSet.of());
            }
        }
        MapBuilder aliasToIndexToSearchRoutingMap = MapBuilder.newMapBuilder();
        for (Map.Entry alias : tmpAliasToIndexToSearchRoutingMap.map().entrySet()) {
            aliasToIndexToSearchRoutingMap.put(alias.getKey(), ((MapBuilder)alias.getValue()).immutableMap());
        }
        this.aliasToIndexToSearchRoutingMap = aliasToIndexToSearchRoutingMap.immutableMap();
        MapBuilder filteringRequiredMap = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices.values()) {
            MapBuilder<String, Boolean> indexFilteringRequiredMap = MapBuilder.newMapBuilder();
            indexFilteringRequiredMap.put(indexMetaData.index(), false);
            for (AliasMetaData aliasMetaData : indexMetaData.aliases().values()) {
                if (aliasMetaData.filter() != null) {
                    indexFilteringRequiredMap.put(aliasMetaData.alias(), true);
                    continue;
                }
                indexFilteringRequiredMap.put(aliasMetaData.alias(), false);
            }
            filteringRequiredMap.put(indexMetaData.index(), indexFilteringRequiredMap.immutableMap());
        }
        this.indexToAliasFilteringRequiredMap = filteringRequiredMap.immutableMap();
        MapBuilder tmpAliasAndIndexToIndexBuilder = MapBuilder.newMapBuilder();
        for (IndexMetaData indexMetaData : indices.values()) {
            Set<String> lst = (HashSet<String>)tmpAliasAndIndexToIndexBuilder.get(indexMetaData.index());
            if (lst == null) {
                lst = Sets.newHashSet();
                tmpAliasAndIndexToIndexBuilder.put(indexMetaData.index(), lst);
            }
            lst.add(indexMetaData.index());
            for (String alias : indexMetaData.aliases().keySet()) {
                lst = (Set)tmpAliasAndIndexToIndexBuilder.get(alias);
                if (lst == null) {
                    lst = Sets.newHashSet();
                    tmpAliasAndIndexToIndexBuilder.put(alias, lst);
                }
                lst.add(indexMetaData.index());
            }
        }
        MapBuilder aliasAndIndexToIndexBuilder = MapBuilder.newMapBuilder();
        for (Map.Entry entry : tmpAliasAndIndexToIndexBuilder.map().entrySet()) {
            aliasAndIndexToIndexBuilder.put(entry.getKey(), ((Set)entry.getValue()).toArray(new String[((Set)entry.getValue()).size()]));
        }
        this.aliasAndIndexToIndexMap = aliasAndIndexToIndexBuilder.immutableMap();
    }

    public long version() {
        return this.version;
    }

    public ImmutableMap<String, ImmutableMap<String, AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableMap<String, ImmutableMap<String, AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public String[] concreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllIndices() {
        return this.concreteAllIndices();
    }

    public String[] concreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] concreteIndices(String[] indices) throws IndexMissingException {
        return this.concreteIndices(indices, false, false);
    }

    public String[] concreteIndicesIgnoreMissing(String[] indices) {
        return this.concreteIndices(indices, true, false);
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        ImmutableMap<String, AliasMetaData> indexAliases = this.aliases.get(aliasOrIndex);
        if (indexAliases == null || indexAliases.isEmpty()) {
            return routing;
        }
        if (indexAliases.size() > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + indexAliases.keySet() + "], can't execute a single index op");
        }
        AliasMetaData aliasMd = (AliasMetaData)((ImmutableCollection)indexAliases.values()).iterator().next();
        if (aliasMd.indexRouting() != null) {
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new ElasticSearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            routing = aliasMd.indexRouting();
        }
        if (routing != null && routing.indexOf(44) != -1) {
            throw new ElasticSearchIllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + routing + "] that resolved to several routing values, rejecting operation");
        }
        return routing;
    }

    private Map<String, Set<String>> resolveSearchRoutingAllIndices(String routing) {
        if (routing != null) {
            String[] concreteIndices;
            Set<String> r = Strings.splitStringByCommaToSet(routing);
            HashMap<String, Set<String>> routings = Maps.newHashMap();
            for (String index : concreteIndices = this.concreteAllIndices()) {
                routings.put(index, r);
            }
            return routings;
        }
        return null;
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String aliasOrIndex) {
        ImmutableMap<String, ImmutableSet<String>> indexToRoutingMap;
        Map<String, Set<String>> routings = null;
        Set<String> paramRouting = null;
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        if ((indexToRoutingMap = this.aliasToIndexToSearchRoutingMap.get(aliasOrIndex)) != null && !indexToRoutingMap.isEmpty()) {
            for (Map.Entry indexRouting : indexToRoutingMap.entrySet()) {
                THashSet<Object> r;
                if (!((ImmutableSet)indexRouting.getValue()).isEmpty()) {
                    r = new THashSet((Collection)indexRouting.getValue());
                    if (paramRouting != null) {
                        r.retainAll(paramRouting);
                    }
                    if (r.isEmpty()) continue;
                    if (routings == null) {
                        routings = Maps.newHashMap();
                    }
                    routings.put((String)indexRouting.getKey(), (Set<String>)r);
                    continue;
                }
                if (paramRouting == null) continue;
                r = new THashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put((String)indexRouting.getKey(), (Set<String>)r);
            }
        } else if (paramRouting != null) {
            routings = ImmutableMap.of(aliasOrIndex, paramRouting);
        }
        return routings;
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String[] aliasesOrIndices) {
        if (aliasesOrIndices == null || aliasesOrIndices.length == 0) {
            return this.resolveSearchRoutingAllIndices(routing);
        }
        if (aliasesOrIndices.length == 1) {
            if (aliasesOrIndices[0].equals("_all")) {
                return this.resolveSearchRoutingAllIndices(routing);
            }
            return this.resolveSearchRouting(routing, aliasesOrIndices[0]);
        }
        HashMap<String, THashSet<Object>> routings = null;
        Set<String> paramRouting = null;
        HashSet<Object> norouting = Sets.newHashSet();
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        for (String aliasOrIndex : aliasesOrIndices) {
            ImmutableMap<String, ImmutableSet<String>> indexToRoutingMap = this.aliasToIndexToSearchRoutingMap.get(aliasOrIndex);
            if (indexToRoutingMap != null && !indexToRoutingMap.isEmpty()) {
                for (Map.Entry indexRouting : indexToRoutingMap.entrySet()) {
                    THashSet<Object> r;
                    if (norouting.contains(indexRouting.getKey())) continue;
                    if (!((ImmutableSet)indexRouting.getValue()).isEmpty()) {
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        if ((r = (THashSet)routings.get(indexRouting.getKey())) == null) {
                            r = new THashSet();
                            routings.put((String)indexRouting.getKey(), r);
                        }
                        r.addAll((Collection)indexRouting.getValue());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(indexRouting.getKey());
                        continue;
                    }
                    if (norouting.contains(indexRouting.getKey())) continue;
                    norouting.add(indexRouting.getKey());
                    if (paramRouting != null) {
                        r = new THashSet<String>(paramRouting);
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        routings.put((String)indexRouting.getKey(), r);
                        continue;
                    }
                    if (routings == null) continue;
                    routings.remove(indexRouting.getKey());
                }
                continue;
            }
            if (norouting.contains(aliasOrIndex)) continue;
            norouting.add(aliasOrIndex);
            if (paramRouting != null) {
                THashSet<String> r = new THashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put(aliasOrIndex, r);
                continue;
            }
            if (routings == null) continue;
            routings.remove(aliasOrIndex);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    public String[] concreteIndices(String[] indices, boolean ignoreMissing, boolean allOnlyOpen) throws IndexMissingException {
        if (indices == null || indices.length == 0) {
            return allOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
        }
        if (indices.length == 1) {
            String index = indices[0];
            if (index.length() == 0) {
                return allOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
            }
            if (index.equals("_all")) {
                return allOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
            }
            if (this.indices.containsKey(index)) {
                return indices;
            }
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index);
            if (actualLst == null) {
                if (!ignoreMissing) {
                    throw new IndexMissingException(new Index(index));
                }
                return Strings.EMPTY_ARRAY;
            }
            return actualLst;
        }
        boolean possiblyAliased = false;
        for (String index : indices) {
            if (this.indices.containsKey(index)) continue;
            possiblyAliased = true;
            break;
        }
        if (!possiblyAliased) {
            return indices;
        }
        HashSet<String> actualIndices = Sets.newHashSetWithExpectedSize(indices.length);
        for (String index : indices) {
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index);
            if (actualLst == null) {
                if (ignoreMissing) continue;
                throw new IndexMissingException(new Index(index));
            }
            for (String x : actualLst) {
                actualIndices.add(x);
            }
        }
        return actualIndices.toArray(new String[actualIndices.size()]);
    }

    public String concreteIndex(String index) throws IndexMissingException, ElasticSearchIllegalArgumentException {
        if (this.indices.containsKey(index)) {
            return index;
        }
        Object[] lst = this.aliasAndIndexToIndexMap.get(index);
        if (lst == null) {
            throw new IndexMissingException(new Index(index));
        }
        if (lst.length > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + index + "] has more than one indices associated with it [" + Arrays.toString(lst) + "], can't execute a single index op");
        }
        return lst[0];
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.aliasAndIndexToIndexMap.containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public ImmutableMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public String[] filteringAliases(String index, String ... indices) {
        if (indices == null || indices.length == 0) {
            return null;
        }
        if (indices.length == 1) {
            String alias = indices[0];
            if (alias.equals("_all")) {
                return null;
            }
            ImmutableMap<String, Boolean> aliasToFilteringRequiredMap = this.indexToAliasFilteringRequiredMap.get(index);
            if (aliasToFilteringRequiredMap == null) {
                throw new IndexMissingException(new Index(index));
            }
            Boolean filteringRequired = aliasToFilteringRequiredMap.get(alias);
            if (filteringRequired == null || !filteringRequired.booleanValue()) {
                return null;
            }
            return new String[]{alias};
        }
        ArrayList<String> filteringAliases = null;
        for (String alias : indices) {
            ImmutableMap<String, Boolean> aliasToFilteringRequiredMap = this.indexToAliasFilteringRequiredMap.get(index);
            if (aliasToFilteringRequiredMap == null) {
                throw new IndexMissingException(new Index(index));
            }
            Boolean filteringRequired = aliasToFilteringRequiredMap.get(alias);
            if (filteringRequired == null) continue;
            if (filteringRequired.booleanValue()) {
                if (filteringAliases == null) {
                    filteringAliases = Lists.newArrayList();
                }
                filteringAliases.add(alias);
                continue;
            }
            return null;
        }
        if (filteringAliases == null) {
            return null;
        }
        return filteringAliases.toArray(new String[filteringAliases.size()]);
    }

    @Override
    public UnmodifiableIterator<IndexMetaData> iterator() {
        return ((ImmutableCollection)this.indices.values()).iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newMetaDataBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long version;
        private MapBuilder<String, IndexMetaData> indices = MapBuilder.newMapBuilder();
        private MapBuilder<String, IndexTemplateMetaData> templates = MapBuilder.newMapBuilder();

        public Builder metaData(MetaData metaData) {
            this.version = metaData.version;
            this.indices.putAll(metaData.indices);
            this.templates.putAll(metaData.templates);
            return this;
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            return this.put(indexMetaDataBuilder.build());
        }

        public Builder put(IndexMetaData indexMetaData) {
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder remoteTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.map().keySet().toArray(new String[this.indices.map().keySet().size()]);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put(settings)).build());
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.map().keySet().toArray(new String[this.indices.map().keySet().size()]);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).numberOfReplicas(numberOfReplicas).build());
            }
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public MetaData build() {
            return new MetaData(this.version, this.indices.immutableMap(), this.templates.immutableMap());
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("meta-data");
            builder.startObject("templates");
            for (IndexTemplateMetaData template : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent(template, builder, params);
            }
            builder.endObject();
            builder.startObject("indices");
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                currentFieldName = parser.currentName();
                if (token == null) {
                    return builder.build();
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if ("indices".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        builder.put(IndexMetaData.Builder.fromXContent(parser));
                    }
                    continue;
                }
                if (!"templates".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    builder.put(IndexTemplateMetaData.Builder.fromXContent(parser));
                }
            }
            return builder.build();
        }

        public static MetaData readFrom(StreamInput in) throws IOException {
            int i;
            Builder builder = new Builder();
            builder.version = in.readLong();
            int size = in.readVInt();
            for (i = 0; i < size; ++i) {
                builder.put(IndexMetaData.Builder.readFrom(in));
            }
            size = in.readVInt();
            for (i = 0; i < size; ++i) {
                builder.put(IndexTemplateMetaData.Builder.readFrom(in));
            }
            return builder.build();
        }

        public static void writeTo(MetaData metaData, StreamOutput out) throws IOException {
            out.writeLong(metaData.version);
            out.writeVInt(metaData.indices.size());
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.writeTo(indexMetaData, out);
            }
            out.writeVInt(metaData.templates.size());
            for (IndexTemplateMetaData template : metaData.templates.values()) {
                IndexTemplateMetaData.Builder.writeTo(template, out);
            }
        }
    }
}

