/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardRoutingTable
implements Iterable<ShardRouting> {
    final ShardId shardId;
    final ShardRouting primary;
    final ImmutableList<ShardRouting> primaryAsList;
    final ImmutableList<ShardRouting> replicas;
    final ImmutableList<ShardRouting> shards;
    final ImmutableList<ShardRouting> activeShards;
    final ImmutableList<ShardRouting> assignedShards;
    final AtomicInteger counter;
    final boolean allocatedPostApi;

    IndexShardRoutingTable(ShardId shardId, ImmutableList<ShardRouting> shards, boolean allocatedPostApi) {
        this.shardId = shardId;
        this.shards = shards;
        this.allocatedPostApi = allocatedPostApi;
        this.counter = new AtomicInteger(ThreadLocalRandom.current().nextInt(shards.size()));
        ShardRouting primary = null;
        ArrayList<ShardRouting> replicas = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> activeShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> assignedShards = new ArrayList<ShardRouting>();
        for (ShardRouting shard : shards) {
            if (shard.primary()) {
                primary = shard;
            } else {
                replicas.add(shard);
            }
            if (shard.active()) {
                activeShards.add(shard);
            }
            if (!shard.assignedToNode()) continue;
            assignedShards.add(shard);
        }
        this.primary = primary;
        this.primaryAsList = primary != null ? ImmutableList.of(primary) : ImmutableList.of();
        this.replicas = ImmutableList.copyOf(replicas);
        this.activeShards = ImmutableList.copyOf(activeShards);
        this.assignedShards = ImmutableList.copyOf(assignedShards);
    }

    public IndexShardRoutingTable normalizeVersions() {
        if (this.shards.isEmpty()) {
            return this;
        }
        if (this.shards.size() == 1) {
            return this;
        }
        long highestVersion = ((ShardRouting)this.shards.get(0)).version();
        boolean requiresNormalization = false;
        for (int i = 1; i < this.shards.size(); ++i) {
            if (((ShardRouting)this.shards.get(i)).version() != highestVersion) {
                requiresNormalization = true;
            }
            if (((ShardRouting)this.shards.get(i)).version() <= highestVersion) continue;
            highestVersion = ((ShardRouting)this.shards.get(i)).version();
        }
        if (!requiresNormalization) {
            return this;
        }
        ArrayList shardRoutings = new ArrayList(this.shards.size());
        for (int i = 0; i < this.shards.size(); ++i) {
            if (((ShardRouting)this.shards.get(i)).version() == highestVersion) {
                shardRoutings.add(this.shards.get(i));
                continue;
            }
            shardRoutings.add(new ImmutableShardRouting((ShardRouting)this.shards.get(i), highestVersion));
        }
        return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(shardRoutings), this.allocatedPostApi);
    }

    public boolean allocatedPostApi() {
        return this.allocatedPostApi;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    @Override
    public UnmodifiableIterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }

    public int size() {
        return this.shards.size();
    }

    public int getSize() {
        return this.size();
    }

    public ImmutableList<ShardRouting> shards() {
        return this.shards;
    }

    public ImmutableList<ShardRouting> getShards() {
        return this.shards();
    }

    public ImmutableList<ShardRouting> activeShards() {
        return this.activeShards;
    }

    public ImmutableList<ShardRouting> getActiveShards() {
        return this.activeShards();
    }

    public ImmutableList<ShardRouting> assignedShards() {
        return this.assignedShards;
    }

    public ImmutableList<ShardRouting> getAssignedShards() {
        return this.assignedShards;
    }

    public int countWithState(ShardRoutingState state) {
        int count = 0;
        for (ShardRouting shard : this) {
            if (state != shard.state()) continue;
            ++count;
        }
        return count;
    }

    public ShardIterator shardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.shards, this.counter.getAndIncrement());
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.shards);
    }

    public ShardIterator shardsIt(int index) {
        return new PlainShardIterator(this.shardId, this.shards, index);
    }

    public ShardIterator activeShardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.activeShards, this.counter.getAndIncrement());
    }

    public ShardIterator activeShardsIt() {
        return new PlainShardIterator(this.shardId, this.activeShards);
    }

    public ShardIterator activeShardsIt(int index) {
        return new PlainShardIterator(this.shardId, this.activeShards, index);
    }

    public ShardIterator assignedShardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.assignedShards, this.counter.getAndIncrement());
    }

    public ShardIterator assignedShardsIt() {
        return new PlainShardIterator(this.shardId, this.assignedShards);
    }

    public ShardIterator assignedShardsIt(int index) {
        return new PlainShardIterator(this.shardId, this.assignedShards, index);
    }

    public ShardIterator primaryShardIt() {
        return new PlainShardIterator(this.shardId, this.primaryAsList);
    }

    public ShardIterator preferNodeShardsIt(String nodeId) {
        return this.preferNodeShardsIt(nodeId, this.shards);
    }

    public ShardIterator preferNodeActiveShardsIt(String nodeId) {
        return this.preferNodeShardsIt(nodeId, this.activeShards);
    }

    public ShardIterator preferNodeAssignedShardsIt(String nodeId) {
        return this.preferNodeShardsIt(nodeId, this.assignedShards);
    }

    private ShardIterator preferNodeShardsIt(String nodeId, ImmutableList<ShardRouting> shards) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(shards.size());
        int index = Math.abs(this.counter.getAndIncrement());
        for (int i = 0; i < shards.size(); ++i) {
            int loc = (index + i) % shards.size();
            ShardRouting shardRouting = (ShardRouting)shards.get(loc);
            ordered.add(shardRouting);
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.set(i, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardRouting primaryShard() {
        return this.primary;
    }

    public List<ShardRouting> replicaShards() {
        return this.replicas;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public static class Builder {
        private ShardId shardId;
        private final List<ShardRouting> shards;
        private boolean allocatedPostApi;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = Lists.newArrayList(indexShard.shards);
            this.allocatedPostApi = indexShard.allocatedPostApi();
        }

        public Builder(ShardId shardId, boolean allocatedPostApi) {
            this.shardId = shardId;
            this.shards = Lists.newArrayList();
            this.allocatedPostApi = allocatedPostApi;
        }

        public Builder addShard(ImmutableShardRouting shardEntry) {
            for (ShardRouting shard : this.shards) {
                if (!shard.assignedToNode() || !shardEntry.assignedToNode() || !shard.currentNodeId().equals(shardEntry.currentNodeId())) continue;
                return this;
            }
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            if (!this.allocatedPostApi) {
                for (ShardRouting shardRouting : this.shards) {
                    if (!shardRouting.primary() || !shardRouting.active()) continue;
                    this.allocatedPostApi = true;
                }
            }
            return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(this.shards), this.allocatedPostApi);
        }

        public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
            String index = in.readUTF();
            return Builder.readFromThin(in, index);
        }

        public static IndexShardRoutingTable readFromThin(StreamInput in, String index) throws IOException {
            int iShardId = in.readVInt();
            boolean allocatedPostApi = in.readBoolean();
            Builder builder = new Builder(new ShardId(index, iShardId), allocatedPostApi);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                ImmutableShardRouting shard = ImmutableShardRouting.readShardRoutingEntry(in, index, iShardId);
                builder.addShard(shard);
            }
            return builder.build();
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeUTF(indexShard.shardId().index().name());
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeBoolean(indexShard.allocatedPostApi());
            out.writeVInt(indexShard.shards.size());
            for (ShardRouting entry : indexShard) {
                entry.writeToThin(out);
            }
        }
    }
}

