/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.NodeAllocations;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class ShardsAllocation
extends AbstractComponent {
    private final NodeAllocations nodeAllocations;

    public ShardsAllocation() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public ShardsAllocation(Settings settings) {
        this(settings, new NodeAllocations(settings));
    }

    @Inject
    public ShardsAllocation(Settings settings, NodeAllocations nodeAllocations) {
        super(settings);
        this.nodeAllocations = nodeAllocations;
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        StartedRerouteAllocation allocation = new StartedRerouteAllocation(routingNodes, clusterState.nodes(), startedShards);
        this.nodeAllocations.applyStartedShards(this.nodeAllocations, allocation);
        boolean changed = this.applyStartedShards(routingNodes, startedShards);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result applyFailedShard(ClusterState clusterState, ShardRouting failedShard) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        FailedRerouteAllocation allocation = new FailedRerouteAllocation(routingNodes, clusterState.nodes(), failedShard);
        boolean changed = this.applyFailedShard(allocation);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        this.nodeAllocations.applyFailedShards(this.nodeAllocations, allocation);
        this.reroute(allocation);
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        RoutingAllocation allocation = new RoutingAllocation(routingNodes, clusterState.nodes());
        if (!this.reroute(allocation)) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    public RoutingAllocation.Result rerouteWithNoReassign(ClusterState clusterState) {
        RoutingNodes routingNodes = clusterState.routingNodes();
        RoutingAllocation allocation = new RoutingAllocation(routingNodes, clusterState.nodes());
        Collection dataNodes = allocation.nodes().dataNodes().values();
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation.routingNodes(), dataNodes);
        this.applyNewNodes(allocation.routingNodes(), dataNodes);
        if (!(changed |= this.electPrimaries(allocation.routingNodes()))) {
            return new RoutingAllocation.Result(false, clusterState.routingTable(), allocation.explanation());
        }
        return new RoutingAllocation.Result(true, new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData()), allocation.explanation());
    }

    private boolean reroute(RoutingAllocation allocation) {
        Collection dataNodes = allocation.nodes().dataNodes().values();
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation.routingNodes(), dataNodes);
        this.applyNewNodes(allocation.routingNodes(), dataNodes);
        changed |= this.electPrimaries(allocation.routingNodes());
        if (allocation.routingNodes().hasUnassigned()) {
            changed |= this.nodeAllocations.allocateUnassigned(this.nodeAllocations, allocation);
            changed |= this.allocateUnassigned(allocation);
            changed |= this.electPrimaries(allocation.routingNodes());
        }
        return changed |= this.rebalance(allocation);
    }

    private boolean rebalance(RoutingAllocation allocation) {
        boolean relocationPerformed;
        boolean changed = false;
        List<RoutingNode> sortedNodesLeastToHigh = allocation.routingNodes().sortedNodesLeastToHigh();
        if (sortedNodesLeastToHigh.isEmpty()) {
            return false;
        }
        int lowIndex = 0;
        int highIndex = sortedNodesLeastToHigh.size() - 1;
        do {
            relocationPerformed = false;
            while (lowIndex != highIndex) {
                RoutingNode lowRoutingNode = sortedNodesLeastToHigh.get(lowIndex);
                RoutingNode highRoutingNode = sortedNodesLeastToHigh.get(highIndex);
                int averageNumOfShards = allocation.routingNodes().requiredAverageNumberOfShardsPerNode();
                if (highRoutingNode.numberOfOwningShards() <= averageNumOfShards) {
                    --highIndex;
                    continue;
                }
                if (lowRoutingNode.shards().size() >= averageNumOfShards) {
                    ++lowIndex;
                    continue;
                }
                boolean relocated = false;
                List<MutableShardRouting> startedShards = highRoutingNode.shardsWithState(ShardRoutingState.STARTED);
                for (MutableShardRouting startedShard : startedShards) {
                    if (!this.nodeAllocations.canRebalance(startedShard, allocation) || !this.nodeAllocations.canAllocate(startedShard, lowRoutingNode, allocation).allocate()) continue;
                    changed = true;
                    lowRoutingNode.add(new MutableShardRouting(startedShard.index(), startedShard.id(), lowRoutingNode.nodeId(), startedShard.currentNodeId(), startedShard.primary(), ShardRoutingState.INITIALIZING, startedShard.version() + 1L));
                    startedShard.relocate(lowRoutingNode.nodeId());
                    relocated = true;
                    relocationPerformed = true;
                    break;
                }
                if (relocated) continue;
                --highIndex;
            }
        } while (relocationPerformed);
        return changed;
    }

    private boolean electPrimaries(RoutingNodes routingNodes) {
        boolean changed = false;
        block0: for (MutableShardRouting shardEntry : routingNodes.unassigned()) {
            if (!shardEntry.primary() || shardEntry.assignedToNode()) continue;
            boolean elected = false;
            for (RoutingNode routingNode : routingNodes.nodesToShards().values()) {
                for (MutableShardRouting shardEntry2 : routingNode.shards()) {
                    if (!shardEntry.shardId().equals(shardEntry2.shardId()) || !shardEntry2.active()) continue;
                    assert (shardEntry2.assignedToNode());
                    assert (!shardEntry2.primary());
                    changed = true;
                    shardEntry.moveFromPrimary();
                    shardEntry2.moveToPrimary();
                    elected = true;
                    break;
                }
                if (!elected) continue;
                continue block0;
            }
        }
        return changed;
    }

    private boolean allocateUnassigned(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        List<RoutingNode> nodes = routingNodes.sortedNodesLeastToHigh();
        Iterator<MutableShardRouting> unassignedIterator = routingNodes.unassigned().iterator();
        int lastNode = 0;
        block0: while (unassignedIterator.hasNext()) {
            MutableShardRouting shard = unassignedIterator.next();
            for (int i = 0; i < nodes.size(); ++i) {
                int numberOfShardsToAllocate;
                RoutingNode node = nodes.get(lastNode);
                if (++lastNode == nodes.size()) {
                    lastNode = 0;
                }
                if (!this.nodeAllocations.canAllocate(shard, node, allocation).allocate() || (numberOfShardsToAllocate = routingNodes.requiredAverageNumberOfShardsPerNode() - node.shards().size()) <= 0) continue;
                changed = true;
                node.add(shard);
                unassignedIterator.remove();
                continue block0;
            }
        }
        Iterator<MutableShardRouting> it = routingNodes.unassigned().iterator();
        block2: while (it.hasNext()) {
            MutableShardRouting shard = it.next();
            for (RoutingNode routingNode : routingNodes.sortedNodesLeastToHigh()) {
                if (!this.nodeAllocations.canAllocate(shard, routingNode, allocation).allocate()) continue;
                changed = true;
                routingNode.add(shard);
                it.remove();
                continue block2;
            }
        }
        return changed;
    }

    private void applyNewNodes(RoutingNodes routingNodes, Iterable<DiscoveryNode> liveNodes) {
        for (DiscoveryNode node : liveNodes) {
            if (routingNodes.nodesToShards().containsKey(node.id())) continue;
            RoutingNode routingNode = new RoutingNode(node.id());
            routingNodes.nodesToShards().put(node.id(), routingNode);
        }
    }

    private boolean deassociateDeadNodes(RoutingNodes routingNodes, Iterable<DiscoveryNode> liveNodes) {
        boolean changed = false;
        HashSet<String> liveNodeIds = Sets.newHashSet();
        for (DiscoveryNode liveNode : liveNodes) {
            liveNodeIds.add(liveNode.id());
        }
        HashSet<String> nodeIdsToRemove = Sets.newHashSet();
        for (RoutingNode routingNode : routingNodes) {
            Iterator<MutableShardRouting> shardsIterator = routingNode.shards().iterator();
            while (shardsIterator.hasNext()) {
                MutableShardRouting shardRoutingEntry = shardsIterator.next();
                if (!shardRoutingEntry.assignedToNode()) continue;
                boolean relocating = shardRoutingEntry.relocating();
                String relocatingNodeId = shardRoutingEntry.relocatingNodeId();
                boolean isRelocationDestinationShard = relocatingNodeId != null && shardRoutingEntry.initializing();
                boolean currentNodeIsDead = false;
                if (!liveNodeIds.contains(shardRoutingEntry.currentNodeId())) {
                    changed = true;
                    nodeIdsToRemove.add(shardRoutingEntry.currentNodeId());
                    if (!isRelocationDestinationShard) {
                        routingNodes.unassigned().add(shardRoutingEntry);
                    }
                    shardRoutingEntry.deassignNode();
                    currentNodeIsDead = true;
                    shardsIterator.remove();
                }
                if (relocating && !liveNodeIds.contains(relocatingNodeId)) {
                    nodeIdsToRemove.add(relocatingNodeId);
                    if (!currentNodeIsDead) {
                        changed = true;
                        shardRoutingEntry.cancelRelocation();
                    }
                }
                if (!isRelocationDestinationShard || liveNodeIds.contains(relocatingNodeId)) continue;
                changed = true;
                shardsIterator.remove();
            }
        }
        for (String nodeIdToRemove : nodeIdsToRemove) {
            routingNodes.nodesToShards().remove(nodeIdToRemove);
        }
        return changed;
    }

    private boolean applyStartedShards(RoutingNodes routingNodes, Iterable<? extends ShardRouting> startedShardEntries) {
        boolean dirty = false;
        block0: for (ShardRouting shardRouting : startedShardEntries) {
            RoutingNode sourceRoutingNode;
            assert (shardRouting.state() == ShardRoutingState.INITIALIZING);
            String relocatingNodeId = null;
            RoutingNode currentRoutingNode = routingNodes.nodesToShards().get(shardRouting.currentNodeId());
            if (currentRoutingNode != null) {
                for (MutableShardRouting shard : currentRoutingNode) {
                    if (!shard.shardId().equals(shardRouting.shardId())) continue;
                    relocatingNodeId = shard.relocatingNodeId();
                    if (shard.started()) break;
                    dirty = true;
                    shard.moveToStarted();
                    break;
                }
            }
            if (relocatingNodeId == null || (sourceRoutingNode = routingNodes.nodesToShards().get(relocatingNodeId)) == null) continue;
            Iterator<MutableShardRouting> shardsIter = sourceRoutingNode.iterator();
            while (shardsIter.hasNext()) {
                MutableShardRouting shard = shardsIter.next();
                if (!shard.shardId().equals(shardRouting.shardId()) || !shard.relocating()) continue;
                dirty = true;
                shardsIter.remove();
                continue block0;
            }
        }
        return dirty;
    }

    private boolean applyFailedShard(FailedRerouteAllocation allocation) {
        RoutingNode routingNode;
        boolean inRelocation;
        IndexRoutingTable indexRoutingTable = allocation.routingTable().index(allocation.failedShard().index());
        if (indexRoutingTable == null) {
            return false;
        }
        ShardRouting failedShard = allocation.failedShard();
        boolean shardDirty = false;
        boolean bl = inRelocation = failedShard.relocatingNodeId() != null;
        if (inRelocation && (routingNode = allocation.routingNodes().nodesToShards().get(failedShard.currentNodeId())) != null) {
            Iterator<MutableShardRouting> shards = routingNode.iterator();
            while (shards.hasNext()) {
                MutableShardRouting shard = shards.next();
                if (!shard.shardId().equals(failedShard.shardId())) continue;
                shardDirty = true;
                shard.deassignNode();
                shards.remove();
                break;
            }
        }
        String nodeId = inRelocation ? failedShard.relocatingNodeId() : failedShard.currentNodeId();
        RoutingNode currentRoutingNode = allocation.routingNodes().nodesToShards().get(nodeId);
        if (currentRoutingNode == null) {
            return false;
        }
        Iterator<MutableShardRouting> shards = currentRoutingNode.iterator();
        while (shards.hasNext()) {
            MutableShardRouting shard = shards.next();
            if (!shard.shardId().equals(failedShard.shardId())) continue;
            shardDirty = true;
            if (!inRelocation) {
                shard.deassignNode();
                shards.remove();
                break;
            }
            shard.cancelRelocation();
            break;
        }
        if (!shardDirty) {
            return false;
        }
        allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
        if (inRelocation) {
            return true;
        }
        allocation.routingNodes().unassigned().add(new MutableShardRouting(failedShard.index(), failedShard.id(), null, failedShard.primary(), ShardRoutingState.UNASSIGNED, failedShard.version() + 1L));
        return true;
    }
}

