/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;

public class FileSystemUtils {
    private static ESLogger logger = ESLoggerFactory.getLogger(FileSystemUtils.class.getName());
    private static final long mkdirsStallTimeout = TimeValue.timeValueMinutes(5L).millis();
    private static final Object mkdirsMutex = new Object();
    private static volatile Thread mkdirsThread;
    private static volatile long mkdirsStartTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mkdirs(File dir) {
        Object object = mkdirsMutex;
        synchronized (object) {
            boolean bl;
            try {
                mkdirsThread = Thread.currentThread();
                mkdirsStartTime = System.currentTimeMillis();
                bl = dir.mkdirs();
                mkdirsThread = null;
            }
            catch (Throwable throwable) {
                mkdirsThread = null;
                throw throwable;
            }
            return bl;
        }
    }

    public static void checkMkdirsStall(long currentTime) {
        Thread mkdirsThread1 = mkdirsThread;
        long stallTime = currentTime - mkdirsStartTime;
        if (mkdirsThread1 != null && stallTime > mkdirsStallTimeout) {
            logger.error("mkdirs stalled for {} on {}, trying to interrupt", new TimeValue(stallTime), mkdirsThread1.getName());
            mkdirsThread1.interrupt();
        }
    }

    public static int maxOpenFiles(File testDir) {
        boolean dirCreated = false;
        if (!testDir.exists()) {
            dirCreated = true;
            testDir.mkdirs();
        }
        ArrayList<RandomAccessFile> files = new ArrayList<RandomAccessFile>();
        try {
            while (true) {
                files.add(new RandomAccessFile(new File(testDir, "tmp" + files.size()), "rw"));
            }
        }
        catch (IOException ioe) {
            int i = 0;
            for (RandomAccessFile raf : files) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                new File(testDir, "tmp" + i++).delete();
            }
            if (dirCreated) {
                FileSystemUtils.deleteRecursively(testDir);
            }
            return files.size();
        }
    }

    public static boolean hasExtensions(File root, String ... extensions) {
        File[] children;
        if (root != null && root.exists() && root.isDirectory() && (children = root.listFiles()) != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    boolean has = FileSystemUtils.hasExtensions(child, extensions);
                    if (!has) continue;
                    return true;
                }
                for (String extension : extensions) {
                    if (!child.getName().endsWith(extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean deleteRecursively(File root) {
        return FileSystemUtils.deleteRecursively(root, true);
    }

    public static boolean deleteRecursively(File root, boolean deleteRoot) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                for (File aChildren : children) {
                    FileSystemUtils.deleteRecursively(aChildren);
                }
            }
            if (deleteRoot) {
                return root.delete();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncFile(File fileToSync) throws IOException {
        boolean success = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success && retryCount < 5) {
            ++retryCount;
            RandomAccessFile file = null;
            try {
                try {
                    file = new RandomAccessFile(fileToSync, "rw");
                    file.getFD().sync();
                    success = true;
                }
                finally {
                    if (file == null) continue;
                    file.close();
                }
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException(ie.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destinationFile) throws IOException {
        FileInputStream sourceIs = null;
        AbstractInterruptibleChannel source = null;
        FileOutputStream destinationOs = null;
        AbstractInterruptibleChannel destination = null;
        try {
            sourceIs = new FileInputStream(sourceFile);
            source = sourceIs.getChannel();
            destinationOs = new FileOutputStream(destinationFile);
            destination = destinationOs.getChannel();
            ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (sourceIs != null) {
                sourceIs.close();
            }
            if (destination != null) {
                destination.close();
            }
            if (destinationOs != null) {
                destinationOs.close();
            }
        }
    }

    private FileSystemUtils() {
    }
}

