/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.elasticsearch.common.io.stream.StreamInput;

public class BytesStreamInput
extends StreamInput {
    protected byte[] buf;
    protected int pos;
    protected int count;

    public BytesStreamInput(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public BytesStreamInput(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
    }

    public int position() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public byte[] underlyingBuffer() {
        return this.buf;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pos >= this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.pos >= this.count) {
            throw new EOFException();
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, b, offset, len);
        this.pos += len;
    }

    @Override
    public void reset() throws IOException {
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readInt();
        if (utflen == 0) {
            return "";
        }
        if (this.chararr.length < utflen) {
            this.chararr = new char[utflen * 2];
        }
        char[] chararr = this.chararr;
        byte[] bytearr = this.buf;
        int endPos = this.pos + utflen;
        int chararr_count = 0;
        for (count = this.pos; count < endPos && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < endPos) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > endPos) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > endPos) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        this.pos += utflen;
        return new String(chararr, 0, chararr_count);
    }
}

