/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.ChannelUpstreamHandler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

@ChannelHandler.Sharable
public class OpenChannelsHandler
implements ChannelUpstreamHandler {
    private Set<Channel> openChannels = ConcurrentCollections.newConcurrentSet();
    private AtomicLong openChannelsCount = new AtomicLong();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean removed = OpenChannelsHandler.this.openChannels.remove(future.getChannel());
            if (removed) {
                OpenChannelsHandler.this.openChannelsCount.decrementAndGet();
            }
        }
    };

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        boolean added;
        ChannelStateEvent evt;
        if (e instanceof ChannelStateEvent && (evt = (ChannelStateEvent)e).getState() == ChannelState.OPEN && (added = this.openChannels.add(ctx.getChannel()))) {
            this.openChannelsCount.incrementAndGet();
            ctx.getChannel().getCloseFuture().addListener(this.remover);
        }
        ctx.sendUpstream(e);
    }

    public long numberOfOpenChannels() {
        return this.openChannelsCount.get();
    }

    public void close() {
        for (Channel channel : this.openChannels) {
            channel.close().awaitUninterruptibly();
        }
    }
}

