/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.bootstrap;

import java.net.SocketAddress;
import org.elasticsearch.common.netty.bootstrap.Bootstrap;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFactory;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineException;

public class ClientBootstrap
extends Bootstrap {
    public ClientBootstrap() {
    }

    public ClientBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        Channel ch = this.getFactory().newChannel(pipeline);
        ch.getConfig().setOptions(this.getOptions());
        if (localAddress != null) {
            ch.bind(localAddress);
        }
        return ch.connect(remoteAddress);
    }
}

