/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.stream;

import java.io.InputStream;
import java.io.PushbackInputStream;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.handler.stream.ChunkedInput;

public class ChunkedStream
implements ChunkedInput {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private volatile long offset;

    public ChunkedStream(InputStream in) {
        this(in, 8192);
    }

    public ChunkedStream(InputStream in, int chunkSize) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        this.chunkSize = chunkSize;
    }

    public long getTransferredBytes() {
        return this.offset;
    }

    public boolean hasNextChunk() throws Exception {
        int b = this.in.read();
        if (b < 0) {
            return false;
        }
        this.in.unread(b);
        return true;
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.in.close();
    }

    public Object nextChunk() throws Exception {
        int localReadBytes;
        if (!this.hasNextChunk()) {
            return null;
        }
        int availableBytes = this.in.available();
        int chunkSize = availableBytes <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        byte[] chunk = new byte[chunkSize];
        int readBytes = 0;
        while ((localReadBytes = this.in.read(chunk, readBytes, chunkSize - readBytes)) >= 0) {
            this.offset += (long)localReadBytes;
            if ((readBytes += localReadBytes) != chunkSize) continue;
            break;
        }
        return ChannelBuffers.wrappedBuffer(chunk, 0, readBytes);
    }
}

