/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.collect.MapBackedSet;
import org.elasticsearch.common.util.concurrent.ConcurrentHashMapLong;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;

public abstract class ConcurrentCollections {
    private static final boolean useNonBlockingMap = Boolean.parseBoolean(System.getProperty("elasticsearch.useNonBlockingMap", "false"));

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <V> ConcurrentMapLong<V> newConcurrentMapLong() {
        return new ConcurrentHashMapLong();
    }

    public static <V> Set<V> newConcurrentSet() {
        return new MapBackedSet(new ConcurrentHashMap());
    }

    private ConcurrentCollections() {
    }
}

