/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLockFactory;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class NodeEnvironment
extends AbstractComponent {
    private final File nodeFile;
    private final Lock lock;
    private final int localNodeId;

    @Inject
    public NodeEnvironment(Settings settings, Environment environment) throws IOException {
        super(settings);
        if (!DiscoveryNode.nodeRequiresLocalStorage(settings)) {
            this.nodeFile = null;
            this.lock = null;
            this.localNodeId = -1;
            return;
        }
        Lock lock = null;
        File dir = null;
        int localNodeId = -1;
        IOException lastException = null;
        for (int i = 0; i < 50; ++i) {
            dir = new File(new File(environment.dataWithClusterFile(), "nodes"), Integer.toString(i));
            if (!dir.exists()) {
                FileSystemUtils.mkdirs(dir);
            }
            this.logger.trace("obtaining node lock on {} ...", dir.getAbsolutePath());
            try {
                NativeFSLockFactory lockFactory = new NativeFSLockFactory(dir);
                Lock tmpLock = lockFactory.makeLock("node.lock");
                boolean obtained = tmpLock.obtain();
                if (obtained) {
                    lock = tmpLock;
                    localNodeId = i;
                    break;
                }
                this.logger.trace("failed to obtain node lock on {}", dir.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                this.logger.trace("failed to obtain node lock on {}", e, dir.getAbsolutePath());
                lastException = e;
            }
        }
        if (lock == null) {
            throw new IOException("Failed to obtain node lock", lastException);
        }
        this.localNodeId = localNodeId;
        this.lock = lock;
        this.nodeFile = dir;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using node location [{}], local_node_id [{}]", dir, localNodeId);
        }
    }

    public int localNodeId() {
        return this.localNodeId;
    }

    public boolean hasNodeFile() {
        return this.nodeFile != null && this.lock != null;
    }

    public File nodeDataLocation() {
        if (this.nodeFile == null || this.lock == null) {
            throw new ElasticSearchIllegalStateException("node is not configured to store local location");
        }
        return this.nodeFile;
    }

    public File indicesLocation() {
        return new File(this.nodeDataLocation(), "indices");
    }

    public File indexLocation(Index index) {
        return new File(this.indicesLocation(), index.name());
    }

    public File shardLocation(ShardId shardId) {
        return new File(this.indexLocation(shardId.index()), Integer.toString(shardId.id()));
    }

    public void close() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

