/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;

public class HttpServer
extends AbstractLifecycleComponent<HttpServer> {
    private final Environment environment;
    private final HttpServerTransport transport;
    private final RestController restController;
    private final TransportNodesInfoAction nodesInfoAction;
    private final boolean disableSites;
    public static final Map<String, String> DEFAULT_MIME_TYPES;

    @Inject
    public HttpServer(Settings settings, Environment environment, HttpServerTransport transport, RestController restController, TransportNodesInfoAction nodesInfoAction, TransportNodesStatsAction nodesStatsAction) {
        super(settings);
        this.environment = environment;
        this.transport = transport;
        this.restController = restController;
        this.nodesInfoAction = nodesInfoAction;
        this.nodesInfoAction.setHttpServer(this);
        nodesStatsAction.setHttpServer(this);
        this.disableSites = this.componentSettings.getAsBoolean("disable_sites", false);
        transport.httpServerAdapter(new Dispatcher(this));
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.transport.start();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}", this.transport.boundAddress());
        }
        this.nodesInfoAction.putNodeAttribute("http_address", this.transport.boundAddress().publishAddress().toString());
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.nodesInfoAction.removeNodeAttribute("http_address");
        this.transport.stop();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.transport.close();
    }

    public HttpInfo info() {
        return new HttpInfo(this.transport.boundAddress());
    }

    public HttpStats stats() {
        return this.transport.stats();
    }

    public void internalDispatchRequest(HttpRequest request, HttpChannel channel) {
        if (request.rawPath().startsWith("/_plugin/")) {
            this.handlePluginSite(request, channel);
            return;
        }
        if (!this.restController.dispatchRequest(request, channel)) {
            if (request.method() == RestRequest.Method.OPTIONS) {
                StringRestResponse response = new StringRestResponse(RestStatus.OK);
                channel.sendResponse(response);
            } else {
                channel.sendResponse(new StringRestResponse(RestStatus.BAD_REQUEST, "No handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]"));
            }
        }
    }

    private void handlePluginSite(HttpRequest request, HttpChannel channel) {
        if (this.disableSites) {
            channel.sendResponse(new StringRestResponse(RestStatus.FORBIDDEN));
            return;
        }
        if (request.method() != RestRequest.Method.GET) {
            channel.sendResponse(new StringRestResponse(RestStatus.FORBIDDEN));
            return;
        }
        String path = request.rawPath().substring("/_plugin/".length());
        int i1 = path.indexOf(47);
        if (i1 == -1) {
            String pluginName = path;
            Object sitePath = null;
            channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
            return;
        }
        String pluginName = path.substring(0, i1);
        String sitePath = path.substring(i1 + 1);
        if (sitePath.length() == 0) {
            sitePath = "/index.html";
        }
        sitePath = sitePath.replace('/', File.separatorChar);
        File siteFile = new File(new File(this.environment.pluginsFile(), pluginName), "_site");
        File file = new File(siteFile, sitePath);
        if (!file.exists() || file.isHidden()) {
            channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
            return;
        }
        if (!file.isFile()) {
            channel.sendResponse(new StringRestResponse(RestStatus.FORBIDDEN));
            return;
        }
        if (!file.getAbsolutePath().startsWith(siteFile.getAbsolutePath())) {
            channel.sendResponse(new StringRestResponse(RestStatus.FORBIDDEN));
            return;
        }
        try {
            byte[] data = Streams.copyToByteArray(file);
            channel.sendResponse(new BytesRestResponse(data, this.guessMimeType(sitePath)));
        }
        catch (IOException e) {
            channel.sendResponse(new StringRestResponse(RestStatus.INTERNAL_SERVER_ERROR));
        }
    }

    private String guessMimeType(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        String extension = path.substring(lastDot + 1).toLowerCase();
        String mimeType = DEFAULT_MIME_TYPES.get(extension);
        if (mimeType == null) {
            return "";
        }
        return mimeType;
    }

    static {
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("csv", "text/csv");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("xhtml", "application/xhtml+xml");
        mimeTypes.put("json", "application/json");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("svg", "image/svg+xml");
        mimeTypes.put("ico", "image/vnd.microsoft.icon");
        DEFAULT_MIME_TYPES = ImmutableMap.copyOf(mimeTypes);
    }

    static class Dispatcher
    implements HttpServerAdapter {
        private final HttpServer server;

        Dispatcher(HttpServer server) {
            this.server = server;
        }

        @Override
        public void dispatchRequest(HttpRequest request, HttpChannel channel) {
            this.server.internalDispatchRequest(request, channel);
        }
    }
}

