/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.robin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.ExtendedIndexSearcher;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.ReaderSearcherHolder;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.resource.AcquirableResource;
import org.elasticsearch.common.util.concurrent.resource.AcquirableResourceFactory;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsEngineException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineAlreadyStartedException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.threadpool.ThreadPool;

public class RobinEngine
extends AbstractIndexShardComponent
implements Engine {
    private volatile ByteSizeValue indexingBufferSize;
    private volatile int termIndexInterval;
    private volatile int termIndexDivisor;
    private volatile int indexConcurrency;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final AtomicBoolean optimizeMutex = new AtomicBoolean();
    private final long gcDeletesInMillis;
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final AnalysisService analysisService;
    private final SimilarityService similarityService;
    private final BloomCache bloomCache;
    private final boolean asyncLoadBloomFilter;
    private IndexWriter indexWriter;
    private volatile AcquirableResource<ReaderSearcherHolder> nrtResource;
    private volatile boolean closed = false;
    private volatile boolean dirty = false;
    private volatile boolean possibleMergeNeeded = false;
    private volatile boolean flushNeeded = false;
    private volatile int disableFlushCounter = 0;
    private final AtomicBoolean flushing = new AtomicBoolean();
    private final ConcurrentMap<String, VersionValue> versionMap;
    private final Object[] dirtyLocks;
    private final Object refreshMutex = new Object();
    private final ApplySettings applySettings = new ApplySettings();
    private Throwable failedEngine = null;
    private final Object failedEngineMutex = new Object();
    private final CopyOnWriteArrayList<Engine.FailedEngineListener> failedEngineListeners = new CopyOnWriteArrayList();
    private final AtomicLong translogIdGenerator = new AtomicLong();
    private SegmentInfos lastCommittedSegmentInfos;

    @Inject
    public RobinEngine(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexSettingsService indexSettingsService, Store store, SnapshotDeletionPolicy deletionPolicy, Translog translog, MergePolicyProvider mergePolicyProvider, MergeSchedulerProvider mergeScheduler, AnalysisService analysisService, SimilarityService similarityService, BloomCache bloomCache) throws EngineException {
        super(shardId, indexSettings);
        Preconditions.checkNotNull(store, "Store must be provided to the engine");
        Preconditions.checkNotNull(deletionPolicy, "Snapshot deletion policy must be provided to the engine");
        Preconditions.checkNotNull(translog, "Translog must be provided to the engine");
        this.gcDeletesInMillis = indexSettings.getAsTime("index.gc_deletes", TimeValue.timeValueSeconds(60L)).millis();
        this.indexingBufferSize = this.componentSettings.getAsBytesSize("index_buffer_size", new ByteSizeValue(64L, ByteSizeUnit.MB));
        this.termIndexInterval = indexSettings.getAsInt("index.term_index_interval", 128);
        this.termIndexDivisor = indexSettings.getAsInt("index.term_index_divisor", 1);
        this.asyncLoadBloomFilter = this.componentSettings.getAsBoolean("async_load_bloom", true);
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.translog = translog;
        this.mergePolicyProvider = mergePolicyProvider;
        this.mergeScheduler = mergeScheduler;
        this.analysisService = analysisService;
        this.similarityService = similarityService;
        this.bloomCache = bloomCache;
        this.indexConcurrency = indexSettings.getAsInt("index.index_concurrency", 8);
        this.versionMap = new ConcurrentHashMap<String, VersionValue>();
        this.dirtyLocks = new Object[this.indexConcurrency * 10];
        for (int i = 0; i < this.dirtyLocks.length; ++i) {
            this.dirtyLocks[i] = new Object();
        }
        this.indexSettingsService.addListener(this.applySettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        ByteSizeValue preValue = this.indexingBufferSize;
        this.rwl.readLock().lock();
        try {
            this.indexingBufferSize = indexingBufferSize.mbFrac() > 2048.0 ? new ByteSizeValue(2048L, ByteSizeUnit.MB) : indexingBufferSize;
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter != null) {
                indexWriter.getConfig().setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (indexingBufferSize == Engine.INACTIVE_SHARD_INDEXING_BUFFER && preValue != Engine.INACTIVE_SHARD_INDEXING_BUFFER) {
            try {
                this.flush(new Engine.Flush().full(true));
            }
            catch (Exception e) {
                this.logger.warn("failed to flush after setting shard to inactive", e, new Object[0]);
            }
        }
    }

    @Override
    public void addFailedEngineListener(Engine.FailedEngineListener listener) {
        this.failedEngineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws EngineException {
        this.rwl.writeLock().lock();
        try {
            if (this.indexWriter != null) {
                throw new EngineAlreadyStartedException(this.shardId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting engine", new Object[0]);
            }
            try {
                this.indexWriter = this.createWriter();
            }
            catch (IOException e) {
                throw new EngineCreationFailureException(this.shardId, "Failed to create engine", (Throwable)e);
            }
            try {
                if (IndexReader.indexExists((Directory)this.store.directory())) {
                    Map commitUserData = IndexReader.getCommitUserData((Directory)this.store.directory());
                    if (commitUserData.containsKey("translog_id")) {
                        this.translogIdGenerator.set(Long.parseLong((String)commitUserData.get("translog_id")));
                    } else {
                        this.translogIdGenerator.set(System.currentTimeMillis());
                        this.indexWriter.commit(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                    }
                } else {
                    this.translogIdGenerator.set(System.currentTimeMillis());
                    this.indexWriter.commit(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                }
                this.translog.newTranslog(this.translogIdGenerator.get());
                this.nrtResource = this.buildNrtResource(this.indexWriter);
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.store.directory());
                this.lastCommittedSegmentInfos = infos;
            }
            catch (IOException e) {
                try {
                    this.indexWriter.rollback();
                }
                catch (IOException e1) {
                }
                finally {
                    try {
                        this.indexWriter.close();
                    }
                    catch (IOException e1) {}
                }
                throw new EngineCreationFailureException(this.shardId, "Failed to open reader on writer", (Throwable)e);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public TimeValue defaultRefreshInterval() {
        return new TimeValue(1L, TimeUnit.SECONDS);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 11[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerCreate(create, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(create.uid());
        synchronized (object) {
            UidField uidField = create.uidField();
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                uidField.version(create.version());
                if (create.docs().size() > 1) {
                    writer.updateDocuments(create.uid(), create.docs(), create.analyzer());
                } else {
                    writer.updateDocument(create.uid(), create.docs().get(0), create.analyzer());
                }
                Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
                if (create.version() != 0L) {
                    this.versionMap.put(create.uid().text(), new VersionValue(create.version(), false, this.threadPool.estimatedTimeInMillis(), translogLocation));
                }
            } else {
                long updatedVersion;
                long expectedVersion;
                VersionValue versionValue = (VersionValue)this.versionMap.get(create.uid().text());
                long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create.uid()) : (versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
                if (create.origin() == Engine.Operation.Origin.PRIMARY) {
                    if (create.versionType() == VersionType.INTERNAL) {
                        expectedVersion = create.version();
                        if (expectedVersion != 0L && currentVersion != -2L) {
                            if (currentVersion == -1L) {
                                throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), -1L, expectedVersion);
                            }
                            if (expectedVersion != currentVersion) {
                                throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
                            }
                        }
                        updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                    } else {
                        if (currentVersion >= 0L && currentVersion >= create.version()) {
                            throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, create.version());
                        }
                        updatedVersion = create.version();
                    }
                } else {
                    expectedVersion = create.version();
                    if (currentVersion != -2L && (currentVersion != -1L || create.version() != 1L) && expectedVersion <= currentVersion) {
                        throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
                    }
                    updatedVersion = create.version();
                }
                if (versionValue != null ? !versionValue.delete() : currentVersion != -1L) {
                    throw new DocumentAlreadyExistsEngineException(this.shardId, create.type(), create.id());
                }
                uidField.version(updatedVersion);
                create.version(updatedVersion);
                if (create.docs().size() > 1) {
                    writer.addDocuments(create.docs(), create.analyzer());
                } else {
                    writer.addDocument(create.docs().get(0), create.analyzer());
                }
                Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
                this.versionMap.put(create.uid().text(), new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            }
        }
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerIndex(index, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerIndex(Engine.Index index, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            UidField uidField = index.uidField();
            if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                uidField.version(index.version());
                if (index.docs().size() > 1) {
                    writer.updateDocuments(index.uid(), index.docs(), index.analyzer());
                } else {
                    writer.updateDocument(index.uid(), index.docs().get(0), index.analyzer());
                }
                Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
                if (index.version() != 0L) {
                    this.versionMap.put(index.uid().text(), new VersionValue(index.version(), false, this.threadPool.estimatedTimeInMillis(), translogLocation));
                }
            } else {
                long updatedVersion;
                long expectedVersion;
                VersionValue versionValue = (VersionValue)this.versionMap.get(index.uid().text());
                long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
                if (index.origin() == Engine.Operation.Origin.PRIMARY) {
                    if (index.versionType() == VersionType.INTERNAL) {
                        expectedVersion = index.version();
                        if (expectedVersion != 0L && currentVersion != -2L) {
                            if (currentVersion == -1L) {
                                throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), -1L, expectedVersion);
                            }
                            if (expectedVersion != currentVersion) {
                                throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                            }
                        }
                        updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                    } else {
                        if (currentVersion >= 0L && currentVersion >= index.version()) {
                            throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, index.version());
                        }
                        updatedVersion = index.version();
                    }
                } else {
                    expectedVersion = index.version();
                    if (currentVersion != -2L && (currentVersion != -1L || index.version() != 1L) && expectedVersion <= currentVersion) {
                        throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                    }
                    updatedVersion = index.version();
                }
                uidField.version(updatedVersion);
                index.version(updatedVersion);
                if (currentVersion == -1L) {
                    if (index.docs().size() > 1) {
                        writer.addDocuments(index.docs(), index.analyzer());
                    } else {
                        writer.addDocument(index.docs().get(0), index.analyzer());
                    }
                } else if (index.docs().size() > 1) {
                    writer.updateDocuments(index.uid(), index.docs(), index.analyzer());
                } else {
                    writer.updateDocument(index.uid(), index.docs().get(0), index.analyzer());
                }
                Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
                this.versionMap.put(index.uid().text(), new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            }
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerDelete(delete, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(delete.uid());
        synchronized (object) {
            if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                writer.deleteDocuments(delete.uid());
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                if (delete.version() != 0L) {
                    this.versionMap.put(delete.uid().text(), new VersionValue(delete.version(), true, this.threadPool.estimatedTimeInMillis(), translogLocation));
                }
            } else {
                long updatedVersion;
                VersionValue versionValue = (VersionValue)this.versionMap.get(delete.uid().text());
                long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete.uid()) : (versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
                if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
                    if (delete.versionType() == VersionType.INTERNAL) {
                        if (delete.version() != 0L && currentVersion != -2L) {
                            if (currentVersion == -1L) {
                                throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), -1L, delete.version());
                            }
                            if (delete.version() != currentVersion) {
                                throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, delete.version());
                            }
                        }
                        updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                    } else {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), -1L, delete.version());
                        }
                        if (currentVersion >= delete.version()) {
                            throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, delete.version());
                        }
                        updatedVersion = delete.version();
                    }
                } else {
                    if (currentVersion != -2L && currentVersion != -1L && delete.version() <= currentVersion) {
                        throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion - 1L, delete.version());
                    }
                    updatedVersion = delete.version();
                }
                if (currentVersion == -1L) {
                    delete.version(0L).notFound(true);
                } else if (versionValue != null && versionValue.delete()) {
                    delete.version(versionValue.version()).notFound(true);
                } else {
                    delete.version(updatedVersion);
                    writer.deleteDocuments(delete.uid());
                    Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                    this.versionMap.put(delete.uid().text(), new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
                }
            }
        }
    }

    @Override
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId);
            }
            Object query = delete.aliasFilter() == null ? delete.query() : new FilteredQuery(delete.query(), delete.aliasFilter());
            writer.deleteDocuments(query);
            this.translog.add(new Translog.DeleteByQuery(delete));
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteByQueryFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.refreshVersioningTable(System.currentTimeMillis());
    }

    @Override
    public Engine.Searcher searcher() throws EngineException {
        AcquirableResource<ReaderSearcherHolder> holder;
        while (!(holder = this.nrtResource).acquire()) {
            Thread.yield();
        }
        return new RobinSearchResult(holder);
    }

    @Override
    public boolean refreshNeeded() {
        return this.dirty;
    }

    @Override
    public boolean possibleMergeNeeded() {
        return this.possibleMergeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Engine.Refresh refresh) throws EngineException {
        block16: {
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId);
            }
            this.rwl.readLock().lock();
            try {
                IndexWriter currentWriter = this.indexWriter;
                if (currentWriter == null) {
                    throw new EngineClosedException(this.shardId, this.failedEngine);
                }
                try {
                    Object object = this.refreshMutex;
                    synchronized (object) {
                        if (this.dirty || refresh.force()) {
                            this.dirty = false;
                            AcquirableResource<ReaderSearcherHolder> current = this.nrtResource;
                            IndexReader newReader = current.resource().reader().reopen(true);
                            if (newReader != current.resource().reader()) {
                                ExtendedIndexSearcher indexSearcher = new ExtendedIndexSearcher(newReader);
                                indexSearcher.setSimilarity(this.similarityService.defaultSearchSimilarity());
                                this.nrtResource = AcquirableResourceFactory.newAcquirableResource(new ReaderSearcherHolder(indexSearcher));
                                current.markForClose();
                            }
                        }
                    }
                }
                catch (AlreadyClosedException e) {
                }
                catch (Exception e) {
                    if (this.indexWriter == null) {
                        throw new EngineClosedException(this.shardId, this.failedEngine);
                    }
                    if (currentWriter != this.indexWriter) {
                        break block16;
                    }
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (OutOfMemoryError e) {
                    this.failEngine(e);
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Engine.Flush flush) throws EngineException {
        if (this.indexWriter == null) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
        if (this.disableFlushCounter > 0) {
            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
        }
        if (!this.flushing.compareAndSet(false, true)) {
            throw new FlushNotAllowedEngineException(this.shardId, "Already flushing...");
        }
        try {
            block26: {
                if (flush.full()) {
                    this.rwl.writeLock().lock();
                    try {
                        if (this.indexWriter == null) {
                            throw new EngineClosedException(this.shardId, this.failedEngine);
                        }
                        if (this.disableFlushCounter > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        this.dirty = false;
                        try {
                            this.indexWriter.close(false);
                            this.indexWriter = this.createWriter();
                            if (this.flushNeeded) {
                                this.flushNeeded = false;
                                long translogId = this.translogIdGenerator.incrementAndGet();
                                this.indexWriter.commit(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                                this.translog.newTranslog(translogId);
                            }
                            AcquirableResource<ReaderSearcherHolder> current = this.nrtResource;
                            this.nrtResource = this.buildNrtResource(this.indexWriter);
                            current.markForClose();
                            break block26;
                        }
                        catch (Exception e) {
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (OutOfMemoryError e) {
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                    }
                    finally {
                        this.rwl.writeLock().unlock();
                    }
                }
                this.rwl.readLock().lock();
                try {
                    if (this.indexWriter == null) {
                        throw new EngineClosedException(this.shardId, this.failedEngine);
                    }
                    if (this.disableFlushCounter > 0) {
                        throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                    }
                    if (!this.flushNeeded) break block26;
                    this.flushNeeded = false;
                    try {
                        long translogId = this.translogIdGenerator.incrementAndGet();
                        this.translog.newTransientTranslog(translogId);
                        this.indexWriter.commit(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                        this.translog.makeTransientCurrent();
                    }
                    catch (Exception e) {
                        this.translog.revertTransient();
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (OutOfMemoryError e) {
                        this.translog.revertTransient();
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
            try {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.store.directory());
                this.lastCommittedSegmentInfos = infos;
            }
            catch (Exception e) {
                this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
            }
        }
        finally {
            this.flushing.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningTable(long time) {
        this.refresh(new Engine.Refresh(true).force(true));
        for (Map.Entry entry : this.versionMap.entrySet()) {
            String id = (String)entry.getKey();
            Object object = this.dirtyLock(id);
            synchronized (object) {
                VersionValue versionValue = (VersionValue)this.versionMap.get(id);
                if (versionValue == null) {
                    continue;
                }
                if (time - versionValue.time() <= 0L) {
                    continue;
                }
                if (versionValue.delete()) {
                    if (time - versionValue.time() > this.gcDeletesInMillis) {
                        this.versionMap.remove(id);
                    }
                } else {
                    this.versionMap.remove(id);
                }
            }
        }
    }

    @Override
    public void maybeMerge() throws EngineException {
        if (!this.possibleMergeNeeded) {
            return;
        }
        this.possibleMergeNeeded = false;
        this.rwl.readLock().lock();
        try {
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            if (this.indexWriter.getConfig().getMergePolicy() instanceof EnableMergePolicy) {
                ((EnableMergePolicy)this.indexWriter.getConfig().getMergePolicy()).enableMerge();
            }
            this.indexWriter.maybeMerge();
        }
        catch (Exception e) {
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
            if (this.indexWriter != null && this.indexWriter.getConfig().getMergePolicy() instanceof EnableMergePolicy) {
                ((EnableMergePolicy)this.indexWriter.getConfig().getMergePolicy()).disableMerge();
            }
        }
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws EngineException {
        if (optimize.flush()) {
            this.flush(new Engine.Flush());
        }
        if (this.optimizeMutex.compareAndSet(false, true)) {
            this.rwl.readLock().lock();
            try {
                if (this.indexWriter == null) {
                    throw new EngineClosedException(this.shardId, this.failedEngine);
                }
                if (this.indexWriter.getConfig().getMergePolicy() instanceof EnableMergePolicy) {
                    ((EnableMergePolicy)this.indexWriter.getConfig().getMergePolicy()).enableMerge();
                }
                if (optimize.onlyExpungeDeletes()) {
                    this.indexWriter.expungeDeletes(false);
                } else if (optimize.maxNumSegments() <= 0) {
                    this.indexWriter.maybeMerge();
                    this.possibleMergeNeeded = false;
                } else {
                    this.indexWriter.optimize(optimize.maxNumSegments(), false);
                }
            }
            catch (Exception e) {
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (OutOfMemoryError e) {
                this.failEngine(e);
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            finally {
                this.rwl.readLock().unlock();
                if (this.indexWriter != null && this.indexWriter.getConfig().getMergePolicy() instanceof EnableMergePolicy) {
                    ((EnableMergePolicy)this.indexWriter.getConfig().getMergePolicy()).disableMerge();
                }
                this.optimizeMutex.set(false);
            }
        }
        if (optimize.waitForMerge()) {
            this.indexWriter.waitForMerges();
        }
        if (optimize.flush()) {
            this.flush(new Engine.Flush());
        }
        if (optimize.refresh()) {
            this.refresh(new Engine.Refresh(false).force(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        SnapshotIndexCommit snapshotIndexCommit = null;
        Translog.Snapshot traslogSnapshot = null;
        this.rwl.readLock().lock();
        try {
            snapshotIndexCommit = this.deletionPolicy.snapshot();
            traslogSnapshot = this.translog.snapshot();
        }
        catch (Exception e) {
            if (snapshotIndexCommit != null) {
                snapshotIndexCommit.release();
            }
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        try {
            T t = snapshotHandler.snapshot(snapshotIndexCommit, traslogSnapshot);
            return t;
        }
        finally {
            snapshotIndexCommit.release();
            traslogSnapshot.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        Translog.Snapshot phase2Snapshot;
        SnapshotIndexCommit phase1Snapshot;
        this.rwl.writeLock().lock();
        try {
            ++this.disableFlushCounter;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            phase1Snapshot = this.deletionPolicy.snapshot();
        }
        catch (Exception e) {
            --this.disableFlushCounter;
            throw new RecoveryEngineException(this.shardId, 1, "Snapshot failed", (Throwable)e);
        }
        try {
            recoveryHandler.phase1(phase1Snapshot);
        }
        catch (Exception e) {
            --this.disableFlushCounter;
            phase1Snapshot.release();
            throw new RecoveryEngineException(this.shardId, 1, "Execution failed", (Throwable)e);
        }
        try {
            phase2Snapshot = this.translog.snapshot();
        }
        catch (Exception e) {
            --this.disableFlushCounter;
            phase1Snapshot.release();
            throw new RecoveryEngineException(this.shardId, 2, "Snapshot failed", (Throwable)e);
        }
        try {
            recoveryHandler.phase2(phase2Snapshot);
        }
        catch (Exception e) {
            --this.disableFlushCounter;
            phase1Snapshot.release();
            phase2Snapshot.release();
            throw new RecoveryEngineException(this.shardId, 2, "Execution failed", (Throwable)e);
        }
        this.rwl.writeLock().lock();
        Translog.Snapshot phase3Snapshot = null;
        try {
            phase3Snapshot = this.translog.snapshot(phase2Snapshot);
            recoveryHandler.phase3(phase3Snapshot);
        }
        catch (Exception e) {
            throw new RecoveryEngineException(this.shardId, 3, "Execution failed", (Throwable)e);
        }
        finally {
            --this.disableFlushCounter;
            this.rwl.writeLock().unlock();
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (phase3Snapshot != null) {
                phase3Snapshot.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Segment> segments() {
        this.rwl.readLock().lock();
        try {
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            HashMap<String, Segment> segments = new HashMap<String, Segment>();
            Engine.Searcher searcher = this.searcher();
            try {
                IndexReader[] readers;
                for (IndexReader reader : readers = searcher.reader().getSequentialSubReaders()) {
                    assert (reader instanceof SegmentReader);
                    SegmentInfo info = Lucene.getSegmentInfo((SegmentReader)reader);
                    assert (!segments.containsKey(info.name));
                    Segment segment = new Segment(info.name);
                    segment.search = true;
                    segment.docCount = reader.numDocs();
                    segment.delDocCount = reader.numDeletedDocs();
                    try {
                        segment.sizeInBytes = info.sizeInBytes(true);
                    }
                    catch (IOException e) {
                        this.logger.trace("failed to get size for [{}]", e, info.name);
                    }
                    segments.put(info.name, segment);
                }
            }
            finally {
                searcher.release();
            }
            if (this.lastCommittedSegmentInfos != null) {
                SegmentInfos infos = this.lastCommittedSegmentInfos;
                for (SegmentInfo info : infos) {
                    Segment segment = (Segment)segments.get(info.name);
                    if (segment == null) {
                        segment = new Segment(info.name);
                        segment.search = false;
                        segment.committed = true;
                        segment.docCount = info.docCount;
                        try {
                            segment.delDocCount = indexWriter.numDeletedDocs(info);
                        }
                        catch (IOException e) {
                            this.logger.trace("failed to get deleted docs for committed segment", e, new Object[0]);
                        }
                        try {
                            segment.sizeInBytes = info.sizeInBytes(true);
                        }
                        catch (IOException e) {
                            this.logger.trace("failed to get size for [{}]", e, info.name);
                        }
                        segments.put(info.name, segment);
                        continue;
                    }
                    segment.committed = true;
                }
            }
            Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
            Arrays.sort(segmentsArr, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return (int)(o1.generation() - o2.generation());
                }
            });
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticSearchException {
        this.rwl.writeLock().lock();
        try {
            this.innerClose();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failEngine(Throwable failure) {
        Object object = this.failedEngineMutex;
        synchronized (object) {
            if (this.failedEngine != null) {
                return;
            }
            this.logger.warn("failed engine", failure, new Object[0]);
            this.failedEngine = failure;
            for (Engine.FailedEngineListener listener : this.failedEngineListeners) {
                listener.onFailedEngine(this.shardId, failure);
            }
            this.innerClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        if (this.closed) {
            return;
        }
        this.indexSettingsService.removeListener(this.applySettings);
        this.closed = true;
        this.versionMap.clear();
        this.failedEngineListeners.clear();
        try {
            if (this.nrtResource != null) {
                this.nrtResource.forceClose();
            }
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("failed to rollback writer on close", e, new Object[0]);
        }
        finally {
            this.indexWriter = null;
        }
    }

    private Object dirtyLock(String id) {
        int hash = id.hashCode();
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        return this.dirtyLocks[Math.abs(hash) % this.dirtyLocks.length];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.text());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadCurrentVersionFromIndex(Term uid) {
        UnicodeUtil.UTF8Result utf8 = Unicode.fromStringAsUtf8(uid.text());
        Engine.Searcher searcher = this.searcher();
        try {
            for (IndexReader reader : searcher.searcher().subReaders()) {
                long version;
                BloomFilter filter = this.bloomCache.filter(reader, "_uid", this.asyncLoadBloomFilter);
                if (!filter.isPresent(utf8.result, 0, utf8.length) || (version = UidField.loadVersion(reader, uid)) == -1L) continue;
                long l = version;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            searcher.release();
        }
    }

    private IndexWriter createWriter() throws IOException {
        IndexWriter indexWriter = null;
        try {
            if (IndexWriter.isLocked((Directory)this.store.directory())) {
                this.logger.warn("shard is locked, releasing lock", new Object[0]);
                IndexWriter.unlock((Directory)this.store.directory());
            }
            boolean create = !IndexReader.indexExists((Directory)this.store.directory());
            IndexWriterConfig config = new IndexWriterConfig(Lucene.VERSION, (Analyzer)this.analysisService.defaultIndexAnalyzer());
            config.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            config.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            config.setMergeScheduler(this.mergeScheduler.newMergeScheduler());
            config.setMergePolicy(this.mergePolicyProvider.newMergePolicy());
            config.setSimilarity(this.similarityService.defaultIndexSimilarity());
            config.setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            config.setTermIndexInterval(this.termIndexInterval);
            config.setReaderTermsIndexDivisor(this.termIndexDivisor);
            config.setMaxThreadStates(this.indexConcurrency);
            indexWriter = new IndexWriter(this.store.directory(), config);
        }
        catch (IOException e) {
            Lucene.safeClose(indexWriter);
            throw e;
        }
        return indexWriter;
    }

    private AcquirableResource<ReaderSearcherHolder> buildNrtResource(IndexWriter indexWriter) throws IOException {
        IndexReader indexReader = IndexReader.open((IndexWriter)indexWriter, (boolean)true);
        ExtendedIndexSearcher indexSearcher = new ExtendedIndexSearcher(indexReader);
        indexSearcher.setSimilarity(this.similarityService.defaultSearchSimilarity());
        return AcquirableResourceFactory.newAcquirableResource(new ReaderSearcherHolder(indexSearcher));
    }

    static {
        IndexMetaData.addDynamicSettings("index.term_index_interval", "index.term_index_divisor", "index.index_concurrency");
    }

    static class VersionValue {
        private final long version;
        private final boolean delete;
        private final long time;
        private final Translog.Location translogLocation;

        VersionValue(long version, boolean delete, long time, Translog.Location translogLocation) {
            this.version = version;
            this.delete = delete;
            this.time = time;
            this.translogLocation = translogLocation;
        }

        public long time() {
            return this.time;
        }

        public long version() {
            return this.version;
        }

        public boolean delete() {
            return this.delete;
        }

        public Translog.Location translogLocation() {
            return this.translogLocation;
        }
    }

    private static class RobinSearchResult
    implements Engine.Searcher {
        private final AcquirableResource<ReaderSearcherHolder> nrtHolder;

        private RobinSearchResult(AcquirableResource<ReaderSearcherHolder> nrtHolder) {
            this.nrtHolder = nrtHolder;
        }

        @Override
        public IndexReader reader() {
            return this.nrtHolder.resource().reader();
        }

        @Override
        public ExtendedIndexSearcher searcher() {
            return this.nrtHolder.resource().searcher();
        }

        @Override
        public boolean release() throws ElasticSearchException {
            this.nrtHolder.release();
            return true;
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            int termIndexInterval = settings.getAsInt("index.term_index_interval", RobinEngine.this.termIndexInterval);
            int termIndexDivisor = settings.getAsInt("index.term_index_divisor", RobinEngine.this.termIndexDivisor);
            int indexConcurrency = settings.getAsInt("index.index_concurrency", RobinEngine.this.indexConcurrency);
            boolean requiresFlushing = false;
            if (termIndexInterval != RobinEngine.this.termIndexInterval || termIndexDivisor != RobinEngine.this.termIndexDivisor) {
                RobinEngine.this.rwl.readLock().lock();
                try {
                    if (termIndexInterval != RobinEngine.this.termIndexInterval) {
                        RobinEngine.this.logger.info("updating index.term_index_interval from [{}] to [{}]", RobinEngine.this.termIndexInterval, termIndexInterval);
                        RobinEngine.this.termIndexInterval = termIndexInterval;
                        RobinEngine.this.indexWriter.getConfig().setTermIndexInterval(termIndexInterval);
                    }
                    if (termIndexDivisor != RobinEngine.this.termIndexDivisor) {
                        RobinEngine.this.logger.info("updating index.term_index_divisor from [{}] to [{}]", RobinEngine.this.termIndexDivisor, termIndexDivisor);
                        RobinEngine.this.termIndexDivisor = termIndexDivisor;
                        RobinEngine.this.indexWriter.getConfig().setReaderTermsIndexDivisor(termIndexDivisor);
                        requiresFlushing = true;
                    }
                    if (indexConcurrency != RobinEngine.this.indexConcurrency) {
                        RobinEngine.this.logger.info("updating index.index_concurrency from [{}] to [{}]", RobinEngine.this.indexConcurrency, indexConcurrency);
                        RobinEngine.this.indexConcurrency = indexConcurrency;
                        requiresFlushing = true;
                    }
                }
                finally {
                    RobinEngine.this.rwl.readLock().unlock();
                }
                if (requiresFlushing) {
                    RobinEngine.this.flush(new Engine.Flush().full(true));
                }
            }
        }
    }
}

