/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.none;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.RecoveryStatus;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;

public class NoneIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final InternalIndexShard indexShard;
    private final RecoveryStatus recoveryStatus = new RecoveryStatus();

    @Inject
    public NoneIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.indexShard = (InternalIndexShard)indexShard;
    }

    public String toString() {
        return "_none_";
    }

    @Override
    public RecoveryStatus recoveryStatus() {
        return this.recoveryStatus;
    }

    @Override
    public void recover(boolean indexShouldExists, RecoveryStatus recoveryStatus) throws IndexShardGatewayRecoveryException {
        this.recoveryStatus().index().startTime(System.currentTimeMillis());
        try {
            this.indexShard.store().deleteContent();
        }
        catch (IOException e) {
            this.logger.warn("failed to clean store before starting shard", e, new Object[0]);
        }
        this.indexShard.start("post recovery from gateway");
        recoveryStatus.index().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
        recoveryStatus.translog().startTime(System.currentTimeMillis());
        recoveryStatus.translog().time(System.currentTimeMillis() - recoveryStatus.index().startTime());
    }

    @Override
    public String type() {
        return "none";
    }

    @Override
    public SnapshotStatus snapshot(IndexShardGateway.Snapshot snapshot) {
        return null;
    }

    @Override
    public SnapshotStatus lastSnapshotStatus() {
        return null;
    }

    @Override
    public SnapshotStatus currentSnapshotStatus() {
        return null;
    }

    @Override
    public boolean requiresSnapshot() {
        return false;
    }

    @Override
    public boolean requiresSnapshotScheduling() {
        return false;
    }

    @Override
    public void close(boolean delete) {
    }

    @Override
    public IndexShardGateway.SnapshotLock obtainSnapshotLock() throws Exception {
        return NO_SNAPSHOT_LOCK;
    }
}

