/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FailedToGenerateSourceMapperException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.AnalyzerMapper;
import org.elasticsearch.index.mapper.internal.BoostFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public class DocumentMapper
implements ToXContent {
    private ThreadLocal<ParseContext> cache = new ThreadLocal<ParseContext>(){

        @Override
        protected ParseContext initialValue() {
            return new ParseContext(DocumentMapper.this.index, DocumentMapper.this.docMapperParser, DocumentMapper.this, new ContentPath(0));
        }
    };
    private final String index;
    private final String type;
    private final DocumentMapperParser docMapperParser;
    private volatile ImmutableMap<String, Object> meta;
    private volatile CompressedString mappingSource;
    private final UidFieldMapper uidFieldMapper;
    private final IdFieldMapper idFieldMapper;
    private final TypeFieldMapper typeFieldMapper;
    private final IndexFieldMapper indexFieldMapper;
    private final SourceFieldMapper sourceFieldMapper;
    private final SizeFieldMapper sizeFieldMapper;
    private final RoutingFieldMapper routingFieldMapper;
    private final ParentFieldMapper parentFieldMapper;
    private final BoostFieldMapper boostFieldMapper;
    private final AllFieldMapper allFieldMapper;
    private final AnalyzerMapper analyzerMapper;
    private final RootObjectMapper rootObjectMapper;
    private final NamedAnalyzer indexAnalyzer;
    private final NamedAnalyzer searchAnalyzer;
    private volatile DocumentFieldMappers fieldMappers;
    private volatile ImmutableMap<String, ObjectMapper> objectMappers = ImmutableMap.of();
    private final List<FieldMapperListener> fieldMapperListeners = new CopyOnWriteArrayList<FieldMapperListener>();
    private final List<ObjectMapperListener> objectMapperListeners = new CopyOnWriteArrayList<ObjectMapperListener>();
    private boolean hasNestedObjects = false;
    private final Filter typeFilter;
    private final Object mutex = new Object();

    public DocumentMapper(String index, DocumentMapperParser docMapperParser, RootObjectMapper rootObjectMapper, ImmutableMap<String, Object> meta, UidFieldMapper uidFieldMapper, IdFieldMapper idFieldMapper, TypeFieldMapper typeFieldMapper, IndexFieldMapper indexFieldMapper, SourceFieldMapper sourceFieldMapper, SizeFieldMapper sizeFieldMapper, @Nullable ParentFieldMapper parentFieldMapper, RoutingFieldMapper routingFieldMapper, AllFieldMapper allFieldMapper, AnalyzerMapper analyzerMapper, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, @Nullable BoostFieldMapper boostFieldMapper) {
        this.index = index;
        this.type = rootObjectMapper.name();
        this.docMapperParser = docMapperParser;
        this.meta = meta;
        this.rootObjectMapper = rootObjectMapper;
        this.uidFieldMapper = uidFieldMapper;
        this.idFieldMapper = idFieldMapper;
        this.typeFieldMapper = typeFieldMapper;
        this.indexFieldMapper = indexFieldMapper;
        this.sourceFieldMapper = sourceFieldMapper;
        this.sizeFieldMapper = sizeFieldMapper;
        this.parentFieldMapper = parentFieldMapper;
        this.routingFieldMapper = routingFieldMapper;
        this.allFieldMapper = allFieldMapper;
        this.analyzerMapper = analyzerMapper;
        this.boostFieldMapper = boostFieldMapper;
        this.indexAnalyzer = indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer;
        this.typeFilter = this.typeMapper().fieldFilter(this.type);
        rootObjectMapper.putMapper(idFieldMapper);
        if (boostFieldMapper != null) {
            rootObjectMapper.putMapper(boostFieldMapper);
        }
        if (parentFieldMapper != null) {
            rootObjectMapper.putMapper(parentFieldMapper);
            routingFieldMapper.markAsRequired();
        }
        rootObjectMapper.putMapper(routingFieldMapper);
        final ArrayList<FieldMapper> tempFieldMappers = Lists.newArrayList();
        if (indexFieldMapper.enabled()) {
            tempFieldMappers.add(indexFieldMapper);
        }
        tempFieldMappers.add(typeFieldMapper);
        tempFieldMappers.add(sourceFieldMapper);
        tempFieldMappers.add(sizeFieldMapper);
        tempFieldMappers.add(uidFieldMapper);
        tempFieldMappers.add(allFieldMapper);
        rootObjectMapper.traverse(new FieldMapperListener(){

            @Override
            public void fieldMapper(FieldMapper fieldMapper) {
                tempFieldMappers.add(fieldMapper);
            }
        });
        this.fieldMappers = new DocumentFieldMappers(this, tempFieldMappers);
        final HashMap objectMappers = Maps.newHashMap();
        rootObjectMapper.traverse(new ObjectMapperListener(){

            @Override
            public void objectMapper(ObjectMapper objectMapper) {
                objectMappers.put(objectMapper.fullPath(), objectMapper);
            }
        });
        this.objectMappers = ImmutableMap.copyOf(objectMappers);
        for (ObjectMapper objectMapper : objectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            this.hasNestedObjects = true;
        }
        this.refreshSource();
    }

    public String type() {
        return this.type;
    }

    public ImmutableMap<String, Object> meta() {
        return this.meta;
    }

    public CompressedString mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.rootObjectMapper;
    }

    public UidFieldMapper uidMapper() {
        return this.uidFieldMapper;
    }

    public IdFieldMapper idMapper() {
        return this.idFieldMapper;
    }

    public IndexFieldMapper indexMapper() {
        return this.indexFieldMapper;
    }

    public TypeFieldMapper typeMapper() {
        return this.typeFieldMapper;
    }

    public SourceFieldMapper sourceMapper() {
        return this.sourceFieldMapper;
    }

    public BoostFieldMapper boostMapper() {
        return this.boostFieldMapper;
    }

    public AllFieldMapper allFieldMapper() {
        return this.allFieldMapper;
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.routingFieldMapper;
    }

    public ParentFieldMapper parentFieldMapper() {
        return this.parentFieldMapper;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Filter typeFilter() {
        return this.typeFilter;
    }

    public boolean hasNestedObjects() {
        return this.hasNestedObjects;
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public ImmutableMap<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(byte[] source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source));
    }

    public ParsedDocument parse(String type, String id, byte[] source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source).type(type).id(id));
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.parse(source, null);
    }

    public ParsedDocument parse(SourceToParse source, @Nullable ParseListener listener) throws MapperParsingException {
        ParseContext context = this.cache.get();
        if (source.type() != null && !source.type().equals(this.type)) {
            throw new MapperParsingException("Type mismatch, provide type [" + source.type() + "] but mapper is of type [" + this.type + "]");
        }
        source.type(this.type);
        XContentParser parser = source.parser();
        try {
            if (parser == null) {
                if (LZF.isCompressed(source.source())) {
                    BytesStreamInput siBytes = new BytesStreamInput(source.source());
                    LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
                    XContentType contentType = XContentFactory.xContentType(siLzf);
                    siLzf.resetToBufferStart();
                    parser = XContentFactory.xContent(contentType).createParser(siLzf);
                } else {
                    parser = XContentFactory.xContent(source.source()).createParser(source.source());
                }
            }
            context.reset(parser, new Document(), this.type, source.source(), source.flyweight(), listener);
            int countDownTokens = 0;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new MapperParsingException("Malformed content, must start with an object");
            }
            boolean emptyDoc = false;
            token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                emptyDoc = true;
            } else if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
            if (this.type.equals(parser.currentName())) {
                token = parser.nextToken();
                ++countDownTokens;
            }
            if (this.sizeFieldMapper.enabled()) {
                context.externalValue(source.source().length);
                this.sizeFieldMapper.parse(context);
            }
            if (this.sourceFieldMapper.enabled()) {
                this.sourceFieldMapper.parse(context);
            }
            if (source.id() != null) {
                context.id(source.id());
                this.uidFieldMapper.parse(context);
            }
            this.typeFieldMapper.parse(context);
            if (source.routing() != null) {
                context.externalValue(source.routing());
                this.routingFieldMapper.parse(context);
            }
            this.indexFieldMapper.parse(context);
            if (!emptyDoc) {
                this.rootObjectMapper.parse(context);
            }
            for (int i = 0; i < countDownTokens; ++i) {
                parser.nextToken();
            }
            if (source.id() == null) {
                if (context.id() == null) {
                    if (!source.flyweight()) {
                        throw new MapperParsingException("No id found while parsing the content source");
                    }
                } else {
                    this.uidFieldMapper.parse(context);
                    if (context.docs().size() > 1) {
                        UidField uidField = (UidField)context.doc().getFieldable("_uid");
                        assert (uidField != null);
                        for (int i = 1; i < context.docs().size(); ++i) {
                            context.docs().get(i).add((Fieldable)new Field("_uid", uidField.uid(), Field.Store.NO, Field.Index.NOT_ANALYZED));
                        }
                    }
                }
            }
            if (context.parsedIdState() != ParseContext.ParsedIdState.PARSED) {
                if (context.id() == null) {
                    if (!source.flyweight()) {
                        throw new MapperParsingException("No id mapping with [_id] found in the content, and not explicitly set");
                    }
                } else {
                    context.parsedId(ParseContext.ParsedIdState.EXTERNAL);
                    this.idFieldMapper.parse(context);
                }
            }
            if (this.parentFieldMapper != null) {
                context.externalValue(source.parent());
                this.parentFieldMapper.parse(context);
            }
            this.analyzerMapper.parse(context);
            this.allFieldMapper.parse(context);
            this.routingFieldMapper.validate(context, source.routing());
        }
        catch (IOException e) {
            throw new MapperParsingException("Failed to parse", e);
        }
        finally {
            if (source.parser() == null && parser != null) {
                parser.close();
            }
        }
        if (context.docs().size() > 1) {
            Collections.reverse(context.docs());
        }
        ParsedDocument doc = new ParsedDocument(context.uid(), context.id(), context.type(), source.routing(), context.docs(), context.analyzer(), context.source(), context.mappersAdded()).parent(source.parent());
        context.reset(null, null, null, null, false, null);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFieldMapper(FieldMapper fieldMapper) {
        Object object = this.mutex;
        synchronized (object) {
            this.fieldMappers = this.fieldMappers.concat(this, fieldMapper);
        }
        for (FieldMapperListener listener : this.fieldMapperListeners) {
            listener.fieldMapper(fieldMapper);
        }
    }

    public void addFieldMapperListener(FieldMapperListener fieldMapperListener, boolean includeExisting) {
        this.fieldMapperListeners.add(fieldMapperListener);
        if (includeExisting) {
            if (this.indexFieldMapper.enabled()) {
                fieldMapperListener.fieldMapper(this.indexFieldMapper);
            }
            fieldMapperListener.fieldMapper(this.sourceFieldMapper);
            fieldMapperListener.fieldMapper(this.sizeFieldMapper);
            fieldMapperListener.fieldMapper(this.typeFieldMapper);
            fieldMapperListener.fieldMapper(this.uidFieldMapper);
            fieldMapperListener.fieldMapper(this.allFieldMapper);
            this.rootObjectMapper.traverse(fieldMapperListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectMapper(ObjectMapper objectMapper) {
        Object object = this.mutex;
        synchronized (object) {
            this.objectMappers = MapBuilder.newMapBuilder(this.objectMappers).put(objectMapper.fullPath(), objectMapper).immutableMap();
            if (objectMapper.nested().isNested()) {
                this.hasNestedObjects = true;
            }
        }
        for (ObjectMapperListener objectMapperListener : this.objectMapperListeners) {
            objectMapperListener.objectMapper(objectMapper);
        }
    }

    public void addObjectMapperListener(ObjectMapperListener objectMapperListener, boolean includeExisting) {
        this.objectMapperListeners.add(objectMapperListener);
        if (includeExisting) {
            this.rootObjectMapper.traverse(objectMapperListener);
        }
    }

    public synchronized MergeResult merge(DocumentMapper mergeWith, MergeFlags mergeFlags) {
        MergeContext mergeContext = new MergeContext(this, mergeFlags);
        this.rootObjectMapper.merge(mergeWith.rootObjectMapper, mergeContext);
        this.allFieldMapper.merge(mergeWith.allFieldMapper, mergeContext);
        this.analyzerMapper.merge(mergeWith.analyzerMapper, mergeContext);
        this.sourceFieldMapper.merge(mergeWith.sourceFieldMapper, mergeContext);
        this.sizeFieldMapper.merge(mergeWith.sizeFieldMapper, mergeContext);
        if (!mergeFlags.simulate()) {
            this.meta = mergeWith.meta();
            this.refreshSource();
        }
        return new MergeResult(mergeContext.buildConflicts());
    }

    public void refreshSource() throws FailedToGenerateSourceMapperException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            this.mappingSource = new CompressedString(builder.string());
        }
        catch (Exception e) {
            throw new FailedToGenerateSourceMapperException(e.getMessage(), e);
        }
    }

    public void close() {
        this.cache.remove();
        this.rootObjectMapper.close();
        this.idFieldMapper.close();
        this.indexFieldMapper.close();
        this.typeFieldMapper.close();
        this.allFieldMapper.close();
        this.analyzerMapper.close();
        this.sourceFieldMapper.close();
        this.sizeFieldMapper.close();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.rootObjectMapper.toXContent(builder, params, new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (DocumentMapper.this.indexAnalyzer != null && DocumentMapper.this.searchAnalyzer != null && DocumentMapper.this.indexAnalyzer.name().equals(DocumentMapper.this.searchAnalyzer.name()) && !DocumentMapper.this.indexAnalyzer.name().startsWith("_")) {
                    if (!DocumentMapper.this.indexAnalyzer.name().equals("default")) {
                        builder.field("analyzer", DocumentMapper.this.indexAnalyzer.name());
                    }
                } else {
                    if (DocumentMapper.this.indexAnalyzer != null && !DocumentMapper.this.indexAnalyzer.name().startsWith("_") && !DocumentMapper.this.indexAnalyzer.name().equals("default")) {
                        builder.field("index_analyzer", DocumentMapper.this.indexAnalyzer.name());
                    }
                    if (DocumentMapper.this.searchAnalyzer != null && !DocumentMapper.this.searchAnalyzer.name().startsWith("_") && !DocumentMapper.this.searchAnalyzer.name().equals("default")) {
                        builder.field("search_analyzer", DocumentMapper.this.searchAnalyzer.name());
                    }
                }
                if (DocumentMapper.this.meta != null && !DocumentMapper.this.meta.isEmpty()) {
                    builder.field("_meta", DocumentMapper.this.meta());
                }
                return builder;
            }
        }, this.indexFieldMapper, this.typeFieldMapper, this.allFieldMapper, this.analyzerMapper, this.sourceFieldMapper, this.sizeFieldMapper);
        return builder;
    }

    public static class Builder {
        private UidFieldMapper uidFieldMapper = new UidFieldMapper();
        private IdFieldMapper idFieldMapper = new IdFieldMapper();
        private TypeFieldMapper typeFieldMapper = new TypeFieldMapper();
        private IndexFieldMapper indexFieldMapper = new IndexFieldMapper();
        private SourceFieldMapper sourceFieldMapper = new SourceFieldMapper();
        private SizeFieldMapper sizeFieldMapper = new SizeFieldMapper();
        private RoutingFieldMapper routingFieldMapper = new RoutingFieldMapper();
        private BoostFieldMapper boostFieldMapper = new BoostFieldMapper();
        private AllFieldMapper allFieldMapper = new AllFieldMapper();
        private AnalyzerMapper analyzerMapper = new AnalyzerMapper();
        private ParentFieldMapper parentFieldMapper = null;
        private NamedAnalyzer indexAnalyzer;
        private NamedAnalyzer searchAnalyzer;
        private final String index;
        private final RootObjectMapper rootObjectMapper;
        private ImmutableMap<String, Object> meta = ImmutableMap.of();
        private Mapper.BuilderContext builderContext = new Mapper.BuilderContext(new ContentPath(1));

        public Builder(String index, @Nullable Settings indexSettings, RootObjectMapper.Builder builder) {
            String idIndexed;
            this.index = index;
            this.rootObjectMapper = (RootObjectMapper)builder.build(this.builderContext);
            if (indexSettings != null && (idIndexed = indexSettings.get("index.mapping._id.indexed")) != null && Booleans.parseBoolean(idIndexed, false)) {
                this.idFieldMapper = new IdFieldMapper(Field.Index.NOT_ANALYZED);
            }
        }

        public Builder meta(ImmutableMap<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder sourceField(SourceFieldMapper.Builder builder) {
            this.sourceFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder sizeField(SizeFieldMapper.Builder builder) {
            this.sizeFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder idField(IdFieldMapper.Builder builder) {
            this.idFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder uidField(UidFieldMapper.Builder builder) {
            this.uidFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder typeField(TypeFieldMapper.Builder builder) {
            this.typeFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder indexField(IndexFieldMapper.Builder builder) {
            this.indexFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder routingField(RoutingFieldMapper.Builder builder) {
            this.routingFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder parentFiled(ParentFieldMapper.Builder builder) {
            this.parentFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder boostField(BoostFieldMapper.Builder builder) {
            this.boostFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder allField(AllFieldMapper.Builder builder) {
            this.allFieldMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder analyzerField(AnalyzerMapper.Builder builder) {
            this.analyzerMapper = builder.build(this.builderContext);
            return this;
        }

        public Builder indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        public boolean hasIndexAnalyzer() {
            return this.indexAnalyzer != null;
        }

        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return this;
        }

        public boolean hasSearchAnalyzer() {
            return this.searchAnalyzer != null;
        }

        public DocumentMapper build(DocumentMapperParser docMapperParser) {
            Preconditions.checkNotNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            return new DocumentMapper(this.index, docMapperParser, this.rootObjectMapper, this.meta, this.uidFieldMapper, this.idFieldMapper, this.typeFieldMapper, this.indexFieldMapper, this.sourceFieldMapper, this.sizeFieldMapper, this.parentFieldMapper, this.routingFieldMapper, this.allFieldMapper, this.analyzerMapper, this.indexAnalyzer, this.searchAnalyzer, this.boostFieldMapper);
        }
    }

    public static class ParseListenerAdapter
    implements ParseListener {
        public boolean beforeFieldAdded(FieldMapper fieldMapper, Fieldable fieldable, Object parseContext) {
            return true;
        }
    }

    public static interface ParseListener<ParseContext> {
        public static final ParseListener EMPTY = new ParseListenerAdapter();

        public boolean beforeFieldAdded(FieldMapper var1, Fieldable var2, ParseContext var3);
    }

    public static class MergeFlags {
        private boolean simulate = true;

        public static MergeFlags mergeFlags() {
            return new MergeFlags();
        }

        public boolean simulate() {
            return this.simulate;
        }

        public MergeFlags simulate(boolean simulate) {
            this.simulate = simulate;
            return this;
        }
    }

    public static class MergeResult {
        private final String[] conflicts;

        public MergeResult(String[] conflicts) {
            this.conflicts = conflicts;
        }

        public boolean hasConflicts() {
            return this.conflicts.length > 0;
        }

        public String[] conflicts() {
            return this.conflicts;
        }
    }
}

