/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.util.concurrent.Immutable;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.query.QueryParseContext;

@ThreadSafe
public interface FieldMapper<T> {
    public Names names();

    public Field.Index index();

    public boolean indexed();

    public boolean analyzed();

    public Field.Store store();

    public boolean stored();

    public Field.TermVector termVector();

    public float boost();

    public boolean omitNorms();

    public boolean omitTermFreqAndPositions();

    public Analyzer indexAnalyzer();

    public Analyzer searchAnalyzer();

    public Object valueForSearch(Fieldable var1);

    public T value(Fieldable var1);

    public T valueFromString(String var1);

    public String valueAsString(Fieldable var1);

    public String indexedValue(String var1);

    public boolean useFieldQueryWithQueryString();

    public Query fieldQuery(String var1, QueryParseContext var2);

    public Query fuzzyQuery(String var1, String var2, int var3, int var4);

    public Query fuzzyQuery(String var1, double var2, int var4, int var5);

    public Query queryStringTermQuery(Term var1);

    public Filter fieldFilter(String var1);

    public Query rangeQuery(String var1, String var2, boolean var3, boolean var4);

    public Filter rangeFilter(String var1, String var2, boolean var3, boolean var4);

    public FieldDataType fieldDataType();

    @Immutable
    public static class Names {
        private final String name;
        private final String indexName;
        private final String indexNameClean;
        private final String fullName;

        public Names(String name) {
            this(name, name, name, name);
        }

        public Names(String name, String indexName, String indexNameClean, String fullName) {
            this.name = name.intern();
            this.indexName = indexName.intern();
            this.indexNameClean = indexNameClean.intern();
            this.fullName = fullName.intern();
        }

        public String name() {
            return this.name;
        }

        public String indexName() {
            return this.indexName;
        }

        public String indexNameClean() {
            return this.indexNameClean;
        }

        public String fullName() {
            return this.fullName;
        }
    }
}

