/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.mapper.geo.GeoPoint;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoHashUtils;

public class MultiValueGeoPointFieldData
extends GeoPointFieldData {
    private static final int VALUE_CACHE_SIZE = 100;
    private static ThreadLocal<ThreadLocals.CleanableValue<GeoPoint[][]>> valuesArrayCache = new ThreadLocal<ThreadLocals.CleanableValue<GeoPoint[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<GeoPoint[][]> initialValue() {
            GeoPoint[][] value = new GeoPoint[100][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new GeoPoint[i];
                for (int j = 0; j < value[i].length; ++j) {
                    value[i][j] = new GeoPoint();
                }
            }
            return new ThreadLocals.CleanableValue<GeoPoint[][]>(value);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> valuesLatCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value = new double[100][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new double[i];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> valuesLonCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value = new double[100][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new double[i];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value);
        }
    };
    private final int[][] ordinals;

    public MultiValueGeoPointFieldData(String fieldName, int[][] ordinals, double[] lat, double[] lon) {
        super(fieldName, lat, lon);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size = super.computeSizeInBytes();
        size += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onValue(docId, GeoHashUtils.encode(this.lat[loc], this.lon[loc]));
        }
        if (!found) {
            proc.onMissing(docId);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, GeoPointFieldData.ValueInDocProc proc) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            proc.onValue(docId, this.lat[loc], this.lon[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onOrdinal(docId, ordinal[docId]);
        }
        if (!found) {
            proc.onOrdinal(docId, 0);
        }
    }

    @Override
    public GeoPoint value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            GeoPoint point = (GeoPoint)((ThreadLocals.CleanableValue)valuesCache.get()).get();
            point.latlon(this.lat[loc], this.lon[loc]);
            return point;
        }
        return null;
    }

    @Override
    public GeoPoint[] values(int docId) {
        int i;
        GeoPoint[] points;
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        if (length < 100) {
            points = valuesArrayCache.get().get()[length];
            i = 0;
            for (int[] ordinal : this.ordinals) {
                int loc = ordinal[docId];
                if (loc == 0) continue;
                points[i++].latlon(this.lat[loc], this.lon[loc]);
            }
        } else {
            points = new GeoPoint[length];
            i = 0;
            for (int[] ordinal : this.ordinals) {
                int loc = ordinal[docId];
                if (loc == 0) continue;
                points[i++] = new GeoPoint(this.lat[loc], this.lon[loc]);
            }
        }
        return points;
    }

    @Override
    public double latValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.lat[loc];
        }
        return 0.0;
    }

    @Override
    public double lonValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.lon[loc];
        }
        return 0.0;
    }

    @Override
    public double[] latValues(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length < 100 ? this.valuesLatCache.get().get()[length] : new double[length];
        int i = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            doubles[i++] = this.lat[loc];
        }
        return doubles;
    }

    @Override
    public double[] lonValues(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length < 100 ? this.valuesLonCache.get().get()[length] : new double[length];
        int i = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            doubles[i++] = this.lon[loc];
        }
        return doubles;
    }
}

