/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.mapper.geo.GeoPoint;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoHashUtils;

public class SingleValueGeoPointFieldData
extends GeoPointFieldData {
    private static ThreadLocal<ThreadLocals.CleanableValue<GeoPoint[]>> valuesArrayCache = new ThreadLocal<ThreadLocals.CleanableValue<GeoPoint[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<GeoPoint[]> initialValue() {
            GeoPoint[] value = new GeoPoint[]{new GeoPoint()};
            return new ThreadLocals.CleanableValue<GeoPoint[]>(value);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<double[]>> valuesLatCache = new ThreadLocal<ThreadLocals.CleanableValue<double[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[]> initialValue() {
            return new ThreadLocals.CleanableValue<double[]>(new double[1]);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<double[]>> valuesLonCache = new ThreadLocal<ThreadLocals.CleanableValue<double[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[]> initialValue() {
            return new ThreadLocals.CleanableValue<double[]>(new double[1]);
        }
    };
    private final int[] ordinals;

    public SingleValueGeoPointFieldData(String fieldName, int[] ordinals, double[] lat, double[] lon) {
        super(fieldName, lat, lon);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        return super.computeSizeInBytes() + (long)(4 * this.ordinals.length) + (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    @Override
    public boolean multiValued() {
        return false;
    }

    @Override
    public boolean hasValue(int docId) {
        return this.ordinals[docId] != 0;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, GeoHashUtils.encode(this.lat[loc], this.lon[loc]));
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc) {
        proc.onOrdinal(docId, this.ordinals[docId]);
    }

    @Override
    public void forEachValueInDoc(int docId, GeoPointFieldData.ValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        proc.onValue(docId, this.lat[loc], this.lon[loc]);
    }

    @Override
    public GeoPoint value(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return null;
        }
        GeoPoint point = (GeoPoint)((ThreadLocals.CleanableValue)valuesCache.get()).get();
        point.latlon(this.lat[loc], this.lon[loc]);
        return point;
    }

    @Override
    public GeoPoint[] values(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return EMPTY_ARRAY;
        }
        GeoPoint[] ret = valuesArrayCache.get().get();
        ret[0].latlon(this.lat[loc], this.lon[loc]);
        return ret;
    }

    @Override
    public double latValue(int docId) {
        return this.lat[this.ordinals[docId]];
    }

    @Override
    public double lonValue(int docId) {
        return this.lon[this.ordinals[docId]];
    }

    @Override
    public double[] latValues(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] ret = this.valuesLatCache.get().get();
        ret[0] = this.lat[loc];
        return ret;
    }

    @Override
    public double[] lonValues(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] ret = this.valuesLonCache.get().get();
        ret[0] = this.lon[loc];
        return ret;
    }
}

