/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class IndexFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper {
    public static final String NAME = "_index";
    public static final String CONTENT_TYPE = "_index";
    private final boolean enabled;

    public IndexFieldMapper() {
        this("_index", "_index");
    }

    protected IndexFieldMapper(String name, String indexName) {
        this(name, indexName, Defaults.STORE, Defaults.TERM_VECTOR, 1.0f, true, true, false);
    }

    public IndexFieldMapper(String name, String indexName, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, boolean enabled) {
        super(new FieldMapper.Names(name, indexName, indexName, name), Defaults.INDEX, store, termVector, boost, omitNorms, omitTermFreqAndPositions, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.enabled = enabled;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public String value(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public String valueFromString(String value) {
        return value;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    public Term term(String value) {
        return this.termFactory.createTerm(value);
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        if (!this.enabled) {
            return null;
        }
        return new Field(this.names.indexName(), context.index(), this.store, this.index);
    }

    @Override
    protected String contentType() {
        return "_index";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.store == Defaults.STORE && !this.enabled) {
            return builder;
        }
        builder.startObject("_index");
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.enabled) {
            builder.field("enabled", this.enabled);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, IndexFieldMapper> {
        private boolean enabled = false;

        public Builder() {
            super("_index");
            this.indexName = "_index";
            this.index = Defaults.INDEX;
            this.store = Defaults.STORE;
            this.omitNorms = true;
            this.omitTermFreqAndPositions = true;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public IndexFieldMapper build(Mapper.BuilderContext context) {
            return new IndexFieldMapper(this.name, this.indexName, this.store, this.termVector, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.enabled);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_index";
        public static final String INDEX_NAME = "_index";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final Field.Store STORE = Field.Store.NO;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
        public static final boolean ENABLED = false;
    }
}

