/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class TypeFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper {
    public static final String NAME = "_type";
    public static final Term TERM_FACTORY = new Term("_type", "");
    public static final String CONTENT_TYPE = "_type";

    public TypeFieldMapper() {
        this("_type", "_type");
    }

    protected TypeFieldMapper(String name, String indexName) {
        this(name, indexName, Defaults.INDEX, Defaults.STORE, Defaults.TERM_VECTOR, 1.0f, true, true);
    }

    public TypeFieldMapper(String name, String indexName, Field.Index index, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        super(new FieldMapper.Names(name, indexName, indexName, name), index, store, termVector, boost, omitNorms, omitTermFreqAndPositions, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
    }

    public String value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public String value(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public String valueFromString(String value) {
        return value;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    public Term term(String value) {
        return this.termFactory.createTerm(value);
    }

    @Override
    public Filter fieldFilter(String value) {
        if (this.index == Field.Index.NO) {
            return new PrefixFilter(UidFieldMapper.TERM_FACTORY.createTerm(Uid.typePrefix(value)));
        }
        return new TermFilter(this.termFactory.createTerm(value));
    }

    @Override
    public Query fieldQuery(String value, QueryParseContext context) {
        return new DeletionAwareConstantScoreQuery(context.cacheFilter(this.fieldFilter(value), null));
    }

    @Override
    public boolean useFieldQueryWithQueryString() {
        return true;
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        if (this.index == Field.Index.NO && this.store == Field.Store.NO) {
            return null;
        }
        return new Field(this.names.indexName(), false, context.type(), this.store, this.index, this.termVector);
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.store == Defaults.STORE && this.index == Defaults.INDEX) {
            return builder;
        }
        builder.startObject("_type");
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, TypeFieldMapper> {
        public Builder() {
            super("_type");
            this.indexName = "_type";
            this.index = Defaults.INDEX;
            this.store = Defaults.STORE;
            this.omitNorms = true;
            this.omitTermFreqAndPositions = true;
        }

        @Override
        public TypeFieldMapper build(Mapper.BuilderContext context) {
            return new TypeFieldMapper(this.name, this.indexName, this.index, this.store, this.termVector, this.boost, this.omitNorms, this.omitTermFreqAndPositions);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_type";
        public static final String INDEX_NAME = "_type";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final Field.Store STORE = Field.Store.NO;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
    }
}

