/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.OpenFilterClause;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class BoolFilterParser
implements FilterParser {
    public static final String NAME = "bool";

    @Inject
    public BoolFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ArrayList<OpenFilterClause> clauses = Lists.newArrayList();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("must".equals(currentFieldName)) {
                    clauses.add(new OpenFilterClause(parseContext.parseInnerFilter(), BooleanClause.Occur.MUST));
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    clauses.add(new OpenFilterClause(parseContext.parseInnerFilter(), BooleanClause.Occur.MUST_NOT));
                    continue;
                }
                if (!"should".equals(currentFieldName)) continue;
                clauses.add(new OpenFilterClause(parseContext.parseInnerFilter(), BooleanClause.Occur.SHOULD));
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("must".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        clauses.add(new OpenFilterClause(parseContext.parseInnerFilter(), BooleanClause.Occur.MUST));
                    }
                    continue;
                }
                if ("must_not".equals(currentFieldName) || "mustNot".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        clauses.add(new OpenFilterClause(parseContext.parseInnerFilter(), BooleanClause.Occur.MUST_NOT));
                    }
                    continue;
                }
                if (!"should".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    clauses.add(new OpenFilterClause(parseContext.parseInnerFilter(), BooleanClause.Occur.SHOULD));
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if (!"_cache_key".equals(currentFieldName) && !"_cacheKey".equals(currentFieldName)) continue;
            cacheKey = new CacheKeyFilter.Key(parser.text());
        }
        XBooleanFilter boolFilter = new XBooleanFilter();
        for (OpenFilterClause filterClause : clauses) {
            boolFilter.add(filterClause);
        }
        XBooleanFilter filter = boolFilter;
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

